/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util.iso;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.Iso;
import org.apache.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.sparql.util.NodeUtils;

public class BNodeIso
implements EqualityTest {
    private NodeIsomorphismMap mapping = new NodeIsomorphismMap();
    private EqualityTest literalTest;

    public static EqualityTest bnodeIsoByTerm() {
        return new BNodeIso(NodeUtils.sameRdfTerm);
    }

    public static EqualityTest bnodeIsoByValue() {
        return new BNodeIso(NodeUtils.sameValue);
    }

    private BNodeIso(EqualityTest literalTest) {
        this.literalTest = literalTest;
    }

    @Override
    public boolean equal(Node n1, Node n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null) {
            return false;
        }
        if (n2 == null) {
            return false;
        }
        if (n1.isURI() && n2.isURI()) {
            return n1.equals(n2);
        }
        if (n1.isLiteral() && n2.isLiteral()) {
            return this.literalTest.equal(n1, n2);
        }
        if (n1.isBlank() && n2.isBlank()) {
            return Iso.nodeIso(n1, n2, this.mapping);
        }
        if (n1.isVariable() && n2.isVariable()) {
            return this.mapping.makeIsomorphic(n1, n2);
        }
        if (n1.isTripleTerm() && n2.isTripleTerm()) {
            Triple t1 = n1.getTriple();
            Triple t2 = n2.getTriple();
            return Iso.tripleIso(t1, t2, this.mapping);
        }
        return false;
    }

    public static enum Match {
        BNODES_TERM,
        BNODES_VALUE,
        EXACT_TERM,
        EXACT_VALUE;

    }
}

