/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl;

import org.apache.jena.graph.Graph;
import org.apache.jena.shacl.ShaclValidationException;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;

public class GraphValidation {
    public static ValidationReport updateAndReport(Shapes shapes, Graph data, Runnable update2) {
        try {
            return GraphValidation.update(shapes, data, update2);
        }
        catch (ShaclValidationException ex) {
            return ex.getReport();
        }
    }

    public static ValidationReport update(Shapes shapes, Graph data, Runnable update2) throws ShaclValidationException {
        return data.getTransactionHandler().calculateAlways(() -> {
            update2.run();
            ValidationReport report = ShaclValidator.get().validate(shapes, data);
            if (report.conforms()) {
                return report;
            }
            throw new ShaclValidationException(report);
        });
    }
}

