/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanPropertyValueEqualsPredicate
implements Predicate {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String propertyName;
    private final Object propertyValue;
    private final boolean ignoreNull;

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, false);
    }

    public BeanPropertyValueEqualsPredicate(String propertyName, Object propertyValue, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.ignoreNull = ignoreNull;
    }

    @Override
    public boolean evaluate(Object object) {
        boolean evaluation = false;
        try {
            evaluation = this.evaluateValue(this.propertyValue, PropertyUtils.getProperty(object, this.propertyName));
        }
        catch (IllegalArgumentException e2) {
            String errorMsg = "Problem during evaluation. Null value encountered in property path...";
            if (!this.ignoreNull) {
                throw new IllegalArgumentException("Problem during evaluation. Null value encountered in property path...", e2);
            }
            this.log.warn("WARNING: Problem during evaluation. Null value encountered in property path..." + e2);
        }
        catch (IllegalAccessException e3) {
            String errorMsg = "Unable to access the property provided.";
            throw new IllegalArgumentException("Unable to access the property provided.", e3);
        }
        catch (InvocationTargetException e4) {
            String errorMsg = "Exception occurred in property's getter";
            throw new IllegalArgumentException("Exception occurred in property's getter", e4);
        }
        catch (NoSuchMethodException e5) {
            String errorMsg = "Property not found.";
            throw new IllegalArgumentException("Property not found.", e5);
        }
        return evaluation;
    }

    protected boolean evaluateValue(Object expected, Object actual) {
        return expected == actual || expected != null && expected.equals(actual);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

