/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.RegexEngine;
import org.apache.jena.sparql.expr.nodevalue.NodeValueOps;
import org.apache.jena.sparql.util.FmtUtils;

public class E_Regex
extends ExprFunctionN {
    private static final String name = "regex";
    private RegexEngine regexEngine = null;
    private String currentFailMessage = null;

    public E_Regex(Expr expr, Expr pattern) {
        this(expr, pattern, null);
    }

    public E_Regex(Expr expr, Expr pattern, Expr flags) {
        super(name, expr, pattern, flags);
        this.init(pattern, flags);
    }

    public E_Regex(Expr expr, String pattern, String flags) {
        super(name, expr, NodeValue.makeString(pattern), NodeValue.makeString(flags));
        this.init(this.getArg(2), this.getArg(3));
    }

    private void init(Expr pattern, Expr flags) {
        if (!ARQ.isStrictMode()) {
            if (pattern.isConstant() && pattern.getConstant().isString() && (flags == null || flags.isConstant())) {
                this.regexEngine = E_Regex.makeRegexEngine(pattern.getConstant(), flags == null ? null : flags.getConstant());
            }
        }
    }

    @Override
    public NodeValue eval(List<NodeValue> args) {
        boolean b;
        Node arg = NodeValueOps.checkAndGetStringLiteral("REGEX", args.get(0));
        NodeValue vPattern = args.get(1);
        NodeValue vFlags = args.size() == 2 ? null : args.get(2);
        RegexEngine regex = this.regexEngine;
        if (regex == null) {
            try {
                regex = E_Regex.makeRegexEngine(vPattern, vFlags);
            }
            catch (ExprEvalException ex) {
                String m = ex.getMessage();
                if (m != null && !m.equals(this.currentFailMessage)) {
                    Log.warn((Object)this, (String)m);
                }
                this.currentFailMessage = m;
                throw ex;
            }
        }
        return (b = regex.match(arg.getLiteralLexicalForm())) ? NodeValue.TRUE : NodeValue.FALSE;
    }

    public static RegexEngine makeRegexEngine(NodeValue vPattern, NodeValue vFlags) {
        if (!vPattern.isString()) {
            throw new ExprException("REGEX: Pattern is not a string: " + String.valueOf(vPattern));
        }
        if (vFlags != null && !vFlags.isString()) {
            throw new ExprException("REGEX: Pattern flags are not a string: " + String.valueOf(vFlags));
        }
        String flags = vFlags == null ? null : vFlags.getString();
        E_Regex.checkFlags(flags);
        return E_Regex.makeRegexEngine(vPattern.getString(), flags);
    }

    private static void checkFlags(String flags) {
        if (flags == null) {
            return;
        }
        if (!StringUtils.containsOnly((CharSequence)flags, (String)"smixq")) {
            throw new ExprEvalException("REGEX: Only 'smixq' are legal as pattern flags: got \"" + FmtUtils.stringEsc(flags) + "\"");
        }
    }

    public static RegexEngine makeRegexEngine(String pattern, String flags) {
        return RegexEngine.create(pattern, flags);
    }

    @Override
    public Expr copy(ExprList newArgs) {
        if (newArgs.size() == 2) {
            return new E_Regex(newArgs.get(0), newArgs.get(1), null);
        }
        return new E_Regex(newArgs.get(0), newArgs.get(1), newArgs.get(2));
    }
}

