/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.Preconditions;

public class JdkProxySerializer
extends Serializer {
    private static final Field FIELD = ReflectionUtils.getField(Proxy.class, InvocationHandler.class);
    private static final long PROXY_HANDLER_FIELD_OFFSET = Platform.objectFieldOffset(FIELD);
    private static final InvocationHandler STUB_HANDLER = new StubInvocationHandler();
    public static Object SUBT_PROXY = Proxy.newProxyInstance(Serializer.class.getClassLoader(), new Class[]{StubInterface.class}, STUB_HANDLER);

    public JdkProxySerializer(Fory fory, Class cls) {
        super(fory, cls);
        if (cls != ReplaceStub.class) {
            Preconditions.checkArgument(ReflectionUtils.isJdkProxy(cls), "Require a jdk proxy class");
        }
    }

    public void write(MemoryBuffer buffer, Object value) {
        this.fory.writeRef(buffer, value.getClass().getInterfaces());
        this.fory.writeRef(buffer, Proxy.getInvocationHandler(value));
    }

    public Object copy(Object value) {
        Class<?>[] interfaces = value.getClass().getInterfaces();
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(value);
        Preconditions.checkNotNull(interfaces);
        Preconditions.checkNotNull(invocationHandler);
        Object proxy = Proxy.newProxyInstance(this.fory.getClassLoader(), interfaces, STUB_HANDLER);
        if (this.needToCopyRef) {
            this.fory.reference(value, proxy);
        }
        Platform.putObject(proxy, PROXY_HANDLER_FIELD_OFFSET, this.fory.copyObject(invocationHandler));
        return proxy;
    }

    public Object read(MemoryBuffer buffer) {
        RefResolver resolver = this.fory.getRefResolver();
        int refId = resolver.lastPreservedRefId();
        Class[] interfaces = (Class[])this.fory.readRef(buffer);
        Preconditions.checkNotNull(interfaces);
        Object proxy = Proxy.newProxyInstance(this.fory.getClassLoader(), interfaces, STUB_HANDLER);
        resolver.setReadObject(refId, proxy);
        InvocationHandler invocationHandler = (InvocationHandler)this.fory.readRef(buffer);
        Preconditions.checkNotNull(invocationHandler);
        Platform.putObject(proxy, PROXY_HANDLER_FIELD_OFFSET, invocationHandler);
        return proxy;
    }

    public static class ReplaceStub {
    }

    private static interface StubInterface {
        public int apply();
    }

    private static class StubInvocationHandler
    implements InvocationHandler {
        private StubInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new IllegalStateException("Deserialization stub handler still active");
        }
    }
}

