/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.adapter;

import com.github.andrewoma.dexx.collection.SortedSet;
import com.github.andrewoma.dexx.collection.internal.adapter.SetAdapater;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class SortedSetAdapter<E>
extends SetAdapater<E>
implements java.util.SortedSet<E> {
    private SortedSet<E> set;

    public SortedSetAdapter(SortedSet<E> set) {
        super(set);
        this.set = set;
    }

    @Override
    @NotNull
    public Comparator<? super E> comparator() {
        return this.set.comparator();
    }

    @Override
    @NotNull
    public java.util.SortedSet<E> subSet(E fromElement, E toElement) {
        return new SortedSetAdapter<E>(this.set.range(fromElement, true, toElement, false));
    }

    @Override
    @NotNull
    public java.util.SortedSet<E> headSet(E toElement) {
        return new SortedSetAdapter<E>(this.set.to(toElement, false));
    }

    @Override
    @NotNull
    public java.util.SortedSet<E> tailSet(E fromElement) {
        return new SortedSetAdapter<E>(this.set.from(fromElement, true));
    }

    @Override
    public E first() {
        if (this.set.isEmpty()) {
            throw new NoSuchElementException("Empty set");
        }
        return this.set.first();
    }

    @Override
    public E last() {
        if (this.set.isEmpty()) {
            throw new NoSuchElementException("Empty set");
        }
        return this.set.last();
    }
}

