/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.seata.common.exception.ParseEndpointException;
import org.apache.seata.common.metadata.ClusterRole;

public class Node {
    private Endpoint control;
    private Endpoint transaction;
    private Endpoint internal;
    protected double weight = 1.0;
    protected boolean healthy = true;
    protected long timeStamp;
    private String group;
    private ClusterRole role = ClusterRole.MEMBER;
    private String version;
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public Endpoint createEndpoint(String host, int port, String protocol) {
        return new Endpoint(host, port);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ClusterRole getRole() {
        return this.role;
    }

    public void setRole(ClusterRole role) {
        this.role = role;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public Endpoint getControl() {
        return this.control;
    }

    public void setControl(Endpoint control) {
        this.control = control;
    }

    public Endpoint getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Endpoint transaction) {
        this.transaction = transaction;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Endpoint getInternal() {
        return this.internal;
    }

    public void setInternal(Endpoint internal) {
        this.internal = internal;
    }

    public int hashCode() {
        return Objects.hash(this.control, this.transaction);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.control, node.control) && Objects.equals(this.transaction, node.transaction);
    }

    public String toJsonString(ObjectMapper objectMapper) {
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private ExternalEndpoint createExternalEndpoint(String host, int controllerPort, int transactionPort) {
        return new ExternalEndpoint(host, controllerPort, transactionPort);
    }

    public List<ExternalEndpoint> createExternalEndpoints(String external) {
        String[] split;
        ArrayList<ExternalEndpoint> externalEndpoints = new ArrayList<ExternalEndpoint>();
        for (String s : split = external.split(",")) {
            String[] item = s.split(":");
            if (item.length == 3) {
                try {
                    String host = item[0];
                    int controllerPort = Integer.parseInt(item[1]);
                    int transactionPort = Integer.parseInt(item[2]);
                    externalEndpoints.add(this.createExternalEndpoint(host, controllerPort, transactionPort));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ParseEndpointException("Invalid port number in: " + s);
                }
            }
            throw new ParseEndpointException("Invalid format for endpoint: " + s);
        }
        return externalEndpoints;
    }

    public Map<String, Object> updateMetadataWithExternalEndpoints(Map<String, Object> metadata, List<ExternalEndpoint> externalEndpoints) {
        Object obj = metadata.get("external");
        if (obj == null) {
            if (!externalEndpoints.isEmpty()) {
                HashMap<String, Object> metadataMap = new HashMap<String, Object>(metadata);
                metadataMap.put("external", externalEndpoints);
                return metadataMap;
            }
            return metadata;
        }
        if (obj instanceof List) {
            List oldList = (List)obj;
            oldList.addAll(externalEndpoints);
            return metadata;
        }
        throw new ParseEndpointException("Metadata 'external' is not a List.");
    }

    public static class Endpoint {
        private String host;
        private String protocol;
        private int port;

        public Endpoint() {
        }

        public Endpoint(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public Endpoint(String host, int port, String protocol) {
            this.host = host;
            this.port = port;
            this.protocol = protocol;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String createAddress() {
            return this.host + ":" + this.port;
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.protocol);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Endpoint endpoint = (Endpoint)o;
            return Objects.equals(endpoint.host, this.host) && Objects.equals(endpoint.port, this.port) && Objects.equals(endpoint.protocol, this.protocol);
        }

        public String toString() {
            return "Endpoint{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }

    public static class ExternalEndpoint {
        private String host;
        private int controlPort;
        private int transactionPort;

        public ExternalEndpoint(String host, int controlPort, int transactionPort) {
            this.host = host;
            this.controlPort = controlPort;
            this.transactionPort = transactionPort;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getControlPort() {
            return this.controlPort;
        }

        public void setControlPort(int controlPort) {
            this.controlPort = controlPort;
        }

        public int getTransactionPort() {
            return this.transactionPort;
        }

        public void setTransactionPort(int transactionPort) {
            this.transactionPort = transactionPort;
        }
    }
}

