/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.credentials.connection;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.connection.ImplicitAuthenticationParametersDpo;
import org.apache.polaris.core.credentials.connection.CatalogAccessProperty;
import org.apache.polaris.core.credentials.connection.ConnectionCredentialVendor;
import org.apache.polaris.core.credentials.connection.ConnectionCredentials;
import org.apache.polaris.service.credentials.connection.AuthType;

@RequestScoped
@AuthType(value=AuthenticationType.IMPLICIT)
@Priority(value=100)
public class ImplicitConnectionCredentialVendor
implements ConnectionCredentialVendor {
    @Nonnull
    public ConnectionCredentials getConnectionCredentials(@Nonnull ConnectionConfigInfoDpo connectionConfig) {
        Preconditions.checkArgument((boolean)(connectionConfig.getAuthenticationParameters() instanceof ImplicitAuthenticationParametersDpo), (String)"Expected ImplicitAuthenticationParametersDpo, got: %s", (Object)connectionConfig.getAuthenticationParameters().getClass().getName());
        return ConnectionCredentials.builder().put(CatalogAccessProperty.EXPIRES_AT_MS, String.valueOf(Long.MAX_VALUE)).build();
    }
}

