/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth.internal.service;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.polaris.service.auth.internal.service.OAuthTokenErrorResponse;
import org.immutables.value.Generated;

@Generated(from="OAuthTokenErrorResponse", generator="Immutables")
final class ImmutableOAuthTokenErrorResponse
implements OAuthTokenErrorResponse {
    private final String error;
    private final String errorDescription;
    @Nullable
    private final String errorUri;
    private transient int hashCode;

    private ImmutableOAuthTokenErrorResponse(String error, String errorDescription, @Nullable String errorUri) {
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public String getErrorDescription() {
        return this.errorDescription;
    }

    @Override
    @Nullable
    public String getErrorUri() {
        return this.errorUri;
    }

    public final ImmutableOAuthTokenErrorResponse withError(String value) {
        String newValue = Objects.requireNonNull(value, "error");
        if (this.error.equals(newValue)) {
            return this;
        }
        return new ImmutableOAuthTokenErrorResponse(newValue, this.errorDescription, this.errorUri);
    }

    public final ImmutableOAuthTokenErrorResponse withErrorDescription(String value) {
        String newValue = Objects.requireNonNull(value, "errorDescription");
        if (this.errorDescription.equals(newValue)) {
            return this;
        }
        return new ImmutableOAuthTokenErrorResponse(this.error, newValue, this.errorUri);
    }

    public final ImmutableOAuthTokenErrorResponse withErrorUri(@Nullable String value) {
        if (Objects.equals(this.errorUri, value)) {
            return this;
        }
        return new ImmutableOAuthTokenErrorResponse(this.error, this.errorDescription, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuthTokenErrorResponse && this.equalsByValue((ImmutableOAuthTokenErrorResponse)another);
    }

    private boolean equalsByValue(ImmutableOAuthTokenErrorResponse another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.error.equals(another.error) && this.errorDescription.equals(another.errorDescription) && Objects.equals(this.errorUri, another.errorUri);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.error.hashCode();
        h += (h << 5) + this.errorDescription.hashCode();
        h += (h << 5) + Objects.hashCode(this.errorUri);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OAuthTokenErrorResponse").omitNullValues().add("error", (Object)this.error).add("errorDescription", (Object)this.errorDescription).add("errorUri", (Object)this.errorUri).toString();
    }

    public static ImmutableOAuthTokenErrorResponse copyOf(OAuthTokenErrorResponse instance) {
        if (instance instanceof ImmutableOAuthTokenErrorResponse) {
            return (ImmutableOAuthTokenErrorResponse)instance;
        }
        return ImmutableOAuthTokenErrorResponse.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableOAuthTokenErrorResponse.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OAuthTokenErrorResponse", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ERROR = 1L;
        private static final long INIT_BIT_ERROR_DESCRIPTION = 2L;
        private long initBits = 3L;
        private String error;
        private String errorDescription;
        private String errorUri;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OAuthTokenErrorResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.error(instance.getError());
            this.errorDescription(instance.getErrorDescription());
            String errorUriValue = instance.getErrorUri();
            if (errorUriValue != null) {
                this.errorUri(errorUriValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder error(String error) {
            this.error = Objects.requireNonNull(error, "error");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = Objects.requireNonNull(errorDescription, "errorDescription");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorUri(@Nullable String errorUri) {
            this.errorUri = errorUri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.error = null;
            this.errorDescription = null;
            this.errorUri = null;
            return this;
        }

        public ImmutableOAuthTokenErrorResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOAuthTokenErrorResponse(this.error, this.errorDescription, this.errorUri);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("error");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorDescription");
            }
            return "Cannot build OAuthTokenErrorResponse, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

