/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;

public interface ContentFile<F> {
    default public String manifestLocation() {
        return null;
    }

    public Long pos();

    public int specId();

    public FileContent content();

    @Deprecated
    public CharSequence path();

    default public String location() {
        return this.path().toString();
    }

    public FileFormat format();

    public StructLike partition();

    public long recordCount();

    public long fileSizeInBytes();

    public Map<Integer, Long> columnSizes();

    public Map<Integer, Long> valueCounts();

    public Map<Integer, Long> nullValueCounts();

    public Map<Integer, Long> nanValueCounts();

    public Map<Integer, ByteBuffer> lowerBounds();

    public Map<Integer, ByteBuffer> upperBounds();

    public ByteBuffer keyMetadata();

    public List<Long> splitOffsets();

    public List<Integer> equalityFieldIds();

    default public Integer sortOrderId() {
        return null;
    }

    default public Long dataSequenceNumber() {
        return null;
    }

    default public Long fileSequenceNumber() {
        return null;
    }

    default public Long firstRowId() {
        return null;
    }

    public F copy();

    public F copyWithoutStats();

    default public F copyWithStats(Set<Integer> requestedColumnIds) {
        throw new UnsupportedOperationException(this.getClass().getName() + " doesn't implement copyWithStats");
    }

    default public F copy(boolean withStats) {
        return withStats ? this.copy() : this.copyWithoutStats();
    }
}

