/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.VariantValue;

class VariantExpressionUtil {
    private static final Map<Type, PhysicalType> NO_CONVERSION_NEEDED = ImmutableMap.builder().put((Object)Types.IntegerType.get(), (Object)PhysicalType.INT32).put((Object)Types.LongType.get(), (Object)PhysicalType.INT64).put((Object)Types.FloatType.get(), (Object)PhysicalType.FLOAT).put((Object)Types.DoubleType.get(), (Object)PhysicalType.DOUBLE).put((Object)Types.DateType.get(), (Object)PhysicalType.DATE).put((Object)Types.TimestampType.withoutZone(), (Object)PhysicalType.TIMESTAMPNTZ).put((Object)Types.TimestampType.withZone(), (Object)PhysicalType.TIMESTAMPTZ).put((Object)Types.StringType.get(), (Object)PhysicalType.STRING).put((Object)Types.BinaryType.get(), (Object)PhysicalType.BINARY).put((Object)Types.UnknownType.get(), (Object)PhysicalType.NULL).build();

    private VariantExpressionUtil() {
    }

    static <T> T castTo(VariantValue value, Type type) {
        if (value == null) {
            return null;
        }
        if (NO_CONVERSION_NEEDED.get(type) == value.type()) {
            return (T)value.asPrimitive().get();
        }
        switch (type.typeId()) {
            case INTEGER: {
                switch (value.type()) {
                    case INT8: 
                    case INT16: {
                        return (T)Integer.valueOf(((Number)value.asPrimitive().get()).intValue());
                    }
                }
                break;
            }
            case LONG: {
                switch (value.type()) {
                    case INT8: 
                    case INT16: 
                    case INT32: {
                        return (T)Long.valueOf(((Number)value.asPrimitive().get()).longValue());
                    }
                }
                break;
            }
            case DOUBLE: {
                if (value.type() != PhysicalType.FLOAT) break;
                return (T)Double.valueOf(((Number)value.asPrimitive().get()).doubleValue());
            }
            case FIXED: {
                ByteBuffer buffer;
                Types.FixedType fixedType = (Types.FixedType)type;
                if (value.type() != PhysicalType.BINARY || (buffer = (ByteBuffer)value.asPrimitive().get()).remaining() != fixedType.length()) break;
                return (T)buffer;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                switch (value.type()) {
                    case DECIMAL4: 
                    case DECIMAL8: 
                    case DECIMAL16: {
                        BigDecimal decimalValue = (BigDecimal)value.asPrimitive().get();
                        if (decimalValue.scale() != decimalType.scale()) break;
                        return (T)decimalValue;
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (value.type()) {
                    case BOOLEAN_FALSE: {
                        return (T)Boolean.FALSE;
                    }
                    case BOOLEAN_TRUE: {
                        return (T)Boolean.TRUE;
                    }
                }
            }
        }
        return null;
    }
}

