/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.implementation.ImplUtils;
import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationPropertyBuilder;
import com.azure.core.util.tracing.TracerProvider;
import java.util.Set;

public class TracingOptions {
    private static final ConfigurationProperty<Boolean> IS_DISABLED_PROPERTY = ConfigurationPropertyBuilder.ofBoolean("tracing.disabled").environmentVariableName("AZURE_TRACING_DISABLED").shared(true).defaultValue(false).build();
    private static final ConfigurationProperty<String> PROVIDER_NAME_PROPERTY = ConfigurationPropertyBuilder.ofString("tracing.provider.implementation").environmentVariableName("AZURE_TRACING_IMPLEMENTATION").shared(true).build();
    private static final Configuration GLOBAL_CONFIG = Configuration.getGlobalConfiguration();
    private final Class<? extends TracerProvider> tracerProvider;
    private Set<String> allowedQueryParamNames;
    private boolean isEnabled;

    public TracingOptions() {
        this(GLOBAL_CONFIG);
    }

    protected TracingOptions(Class<? extends TracerProvider> tracerProvider) {
        this.tracerProvider = tracerProvider;
        this.isEnabled = GLOBAL_CONFIG.get(IS_DISABLED_PROPERTY) == false;
    }

    private TracingOptions(Configuration configuration) {
        this.isEnabled = configuration.get(IS_DISABLED_PROPERTY) == false;
        String className = configuration.get(PROVIDER_NAME_PROPERTY);
        this.tracerProvider = className != null ? ImplUtils.getClassByName(className) : null;
    }

    public static TracingOptions fromConfiguration(Configuration configuration) {
        return new TracingOptions(configuration);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public TracingOptions setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        return this;
    }

    public Class<? extends TracerProvider> getTracerProvider() {
        return this.tracerProvider;
    }

    public Set<String> getAllowedTracingQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public TracingOptions setAllowedTracingQueryParamNames(Set<String> allowedQueryParamNames) {
        this.allowedQueryParamNames = allowedQueryParamNames;
        return this;
    }
}

