/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBProxyTargetGroup;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse;

public class DescribeDBProxyTargetGroupsIterable
implements SdkIterable<DescribeDbProxyTargetGroupsResponse> {
    private final RdsClient client;
    private final DescribeDbProxyTargetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBProxyTargetGroupsIterable(RdsClient client, DescribeDbProxyTargetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbProxyTargetGroupsResponseFetcher();
    }

    public Iterator<DescribeDbProxyTargetGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBProxyTargetGroup> targetGroups() {
        Function<DescribeDbProxyTargetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targetGroups() != null) {
                return response.targetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbProxyTargetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbProxyTargetGroupsResponse> {
        private DescribeDbProxyTargetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbProxyTargetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbProxyTargetGroupsResponse nextPage(DescribeDbProxyTargetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBProxyTargetGroupsIterable.this.client.describeDBProxyTargetGroups(DescribeDBProxyTargetGroupsIterable.this.firstRequest);
            }
            return DescribeDBProxyTargetGroupsIterable.this.client.describeDBProxyTargetGroups((DescribeDbProxyTargetGroupsRequest)((Object)DescribeDBProxyTargetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

