/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import org.apache.cassandra.io.compress.CompressionMetadata;

public class CorruptBlockException
extends IOException {
    public CorruptBlockException(String filePath, CompressionMetadata.Chunk chunk) {
        this(filePath, chunk, null);
    }

    public CorruptBlockException(String filePath, CompressionMetadata.Chunk chunk, Throwable cause) {
        this(filePath, chunk.offset, chunk.length, cause);
    }

    public CorruptBlockException(String filePath, long offset, int length) {
        this(filePath, offset, length, null);
    }

    public CorruptBlockException(String filePath, long offset, int length, Throwable cause) {
        super(String.format("(%s): corruption detected, chunk at %d of length %d.", filePath, offset, length), cause);
    }
}

