/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdGenerator;
import org.apache.hugegraph.struct.schema.PropertyKey;
import org.apache.hugegraph.struct.schema.SchemaLabel;
import org.apache.hugegraph.structure.BaseProperty;
import org.apache.hugegraph.type.GraphType;
import org.apache.hugegraph.type.Idfiable;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.slf4j.Logger;

public abstract class BaseElement
implements GraphType,
Idfiable,
Serializable {
    private static final Logger LOG = Log.logger(BaseElement.class);
    public static final MutableIntObjectMap<BaseProperty<?>> EMPTY_MAP = new IntObjectHashMap();
    private static final int MAX_PROPERTIES = 65535;
    MutableIntObjectMap<BaseProperty<?>> properties = EMPTY_MAP;
    Id id;
    private SchemaLabel schemaLabel;
    long expiredTime;
    private boolean removed = false;
    private boolean fresh = false;
    private boolean propLoaded = true;
    private boolean defaultValueUpdated = false;

    public void setProperties(MutableIntObjectMap<BaseProperty<?>> properties) {
        this.properties = properties;
    }

    @Override
    public Id id() {
        return this.id;
    }

    public void id(Id id) {
        this.id = id;
    }

    public boolean removed() {
        return this.removed;
    }

    public void removed(boolean removed) {
        this.removed = removed;
    }

    public boolean fresh() {
        return this.fresh;
    }

    public void fresh(boolean fresh) {
        this.fresh = fresh;
    }

    public boolean propLoaded() {
        return this.propLoaded;
    }

    public void propLoaded(boolean propLoaded) {
        this.propLoaded = propLoaded;
    }

    public boolean defaultValueUpdated() {
        return this.defaultValueUpdated;
    }

    public void defaultValueUpdated(boolean defaultValueUpdated) {
        this.defaultValueUpdated = defaultValueUpdated;
    }

    public SchemaLabel schemaLabel() {
        return this.schemaLabel;
    }

    public void schemaLabel(SchemaLabel label) {
        this.schemaLabel = label;
    }

    public long expiredTime() {
        return this.expiredTime;
    }

    public void expiredTime(long expiredTime) {
        this.expiredTime = expiredTime;
    }

    public boolean hasTtl() {
        return this.schemaLabel.ttl() > 0L;
    }

    public boolean expired(long now) {
        SchemaLabel label = this.schemaLabel();
        if (label.ttl() == 0L) {
            return false;
        }
        if (this.expiredTime() > 0L) {
            boolean expired = this.expiredTime() < now;
            LOG.debug("The element {} {} with expired time {} and now {}", new Object[]{this, expired ? "expired" : "not expired", this.expiredTime(), now});
            return expired;
        }
        LOG.error("The element {} should have positive expired time, but got {}! ttl is {} ttl start time is {}", new Object[]{this, this.expiredTime(), label.ttl(), label.ttlStartTimeName()});
        if (SchemaLabel.NONE_ID.equals(label.ttlStartTime())) {
            return false;
        }
        Date date = (Date)this.getPropertyValue(label.ttlStartTime());
        if (date == null) {
            return false;
        }
        long expiredTime = date.getTime() + label.ttl();
        boolean expired = expiredTime < now;
        LOG.debug("The element {} {} with expired time {} and now {}", new Object[]{this, expired ? "expired" : "not expired", expiredTime, now});
        return expired;
    }

    public long ttl(long now) {
        if (this.expiredTime() == 0L || this.expiredTime() < now) {
            return 0L;
        }
        return this.expiredTime() - now;
    }

    protected <V> BaseProperty<V> newProperty(PropertyKey pkey, V val) {
        return new BaseProperty<V>(pkey, val);
    }

    public boolean hasProperty(Id key) {
        return this.properties.containsKey(BaseElement.intFromId(key));
    }

    public boolean hasProperties() {
        return this.properties.size() > 0;
    }

    public void setExpiredTimeIfNeeded(long now) {
        SchemaLabel label = this.schemaLabel();
        if (label.ttl() == 0L) {
            return;
        }
        if (SchemaLabel.NONE_ID.equals(label.ttlStartTime())) {
            this.expiredTime(now + label.ttl());
            return;
        }
        Date date = (Date)this.getPropertyValue(label.ttlStartTime());
        if (date == null) {
            this.expiredTime(now + label.ttl());
            return;
        }
        long expired = date.getTime() + label.ttl();
        E.checkArgument((expired > now ? 1 : 0) != 0, (String)"The expired time '%s' of '%s' is prior to now: %s", (Object[])new Object[]{new Date(expired), this, now});
        this.expiredTime(expired);
    }

    public void resetProperties() {
        this.properties = CollectionFactory.newIntObjectMap();
        this.propLoaded(true);
    }

    public <V> V getPropertyValue(Id key) {
        BaseProperty prop = (BaseProperty)this.properties.get(BaseElement.intFromId(key));
        if (prop == null) {
            return null;
        }
        return prop.value();
    }

    public MutableIntObjectMap<BaseProperty<?>> properties() {
        return this.properties;
    }

    public void properties(MutableIntObjectMap<BaseProperty<?>> properties) {
        this.properties = properties;
    }

    public <V> BaseProperty<V> getProperty(Id key) {
        return (BaseProperty)this.properties.get(BaseElement.intFromId(key));
    }

    private <V> BaseProperty<V> addProperty(PropertyKey pkey, V value, Supplier<Collection<V>> supplier) {
        Collection values;
        BaseProperty<Object> property;
        assert (pkey.cardinality().multiple());
        if (this.hasProperty(pkey.id())) {
            property = this.getProperty(pkey.id());
        } else {
            property = this.newProperty(pkey, supplier.get());
            this.addProperty(property);
        }
        if (pkey.cardinality() == Cardinality.SET) {
            values = value instanceof Set ? (Set)value : CollectionUtil.toSet(value);
        } else {
            assert (pkey.cardinality() == Cardinality.LIST);
            values = value instanceof List ? (List)value : CollectionUtil.toList(value);
        }
        ((Collection)property.value()).addAll(values);
        return property;
    }

    public <V> BaseProperty<V> addProperty(PropertyKey pkey, V value) {
        BaseProperty<V> prop = null;
        switch (pkey.cardinality()) {
            case SINGLE: {
                prop = this.newProperty(pkey, value);
                this.addProperty(prop);
                break;
            }
            case SET: {
                prop = this.addProperty(pkey, value, HashSet::new);
                break;
            }
            case LIST: {
                prop = this.addProperty(pkey, value, ArrayList::new);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return prop;
    }

    public <V> BaseProperty<?> addProperty(BaseProperty<V> prop) {
        PropertyKey pkey;
        if (this.properties == EMPTY_MAP) {
            this.properties = new IntObjectHashMap();
        }
        E.checkArgument((this.properties.containsKey(BaseElement.intFromId((pkey = prop.propertyKey()).id())) || this.properties.size() < 65535 ? 1 : 0) != 0, (String)"Exceeded the maximum number of properties", (Object[])new Object[0]);
        return (BaseProperty)this.properties.put(BaseElement.intFromId(pkey.id()), prop);
    }

    public Map<Id, BaseProperty<?>> getProperties() {
        HashMap props = new HashMap();
        for (IntObjectPair e : this.properties.keyValuesView()) {
            props.put(IdGenerator.of(e.getOne()), (BaseProperty)e.getTwo());
        }
        return props;
    }

    public <V> BaseProperty<?> removeProperty(Id key) {
        return (BaseProperty)this.properties.remove(BaseElement.intFromId(key));
    }

    public static int intFromId(Id id) {
        E.checkArgument((boolean)(id instanceof IdGenerator.LongId), (String)"Can't get number from %s(%s)", (Object[])new Object[]{id, id.getClass()});
        return ((IdGenerator.LongId)id).intValue();
    }

    public abstract Object sysprop(HugeKeys var1);

    public Map<Id, Object> getPropertiesMap() {
        HashMap<Id, Object> props = new HashMap<Id, Object>();
        for (IntObjectPair e : this.properties.keyValuesView()) {
            props.put(IdGenerator.of(e.getOne()), ((BaseProperty)e.getTwo()).value());
        }
        return props;
    }

    public int sizeOfProperties() {
        return this.properties.size();
    }

    public int sizeOfSubProperties() {
        int size = 0;
        for (BaseProperty p : this.properties.values()) {
            ++size;
            if (p.propertyKey().cardinality() == Cardinality.SINGLE || !(p.value() instanceof Collection)) continue;
            size += ((Collection)p.value()).size();
        }
        return size;
    }

    public BaseElement clone() throws CloneNotSupportedException {
        return (BaseElement)super.clone();
    }
}

