/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Base64;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdGenerator;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.struct.schema.PropertyKey;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class DirectBinarySerializer {
    protected static final Logger LOG = Log.logger(DirectBinarySerializer.class);

    public DirectHugeElement parseIndex(byte[] key, byte[] value) {
        byte[] rawBytes;
        byte[] expiredTimeBytes;
        int delimiterIndex;
        long expiredTime = 0L;
        if (value.length > 0 && (delimiterIndex = Bytes.indexOf((byte[])value, (byte)0)) >= 0 && (expiredTimeBytes = Arrays.copyOfRange(value, delimiterIndex + 1, value.length)).length > 0 && (rawBytes = Base64.getDecoder().decode(expiredTimeBytes)).length >= 8) {
            expiredTime = Longs.fromByteArray((byte[])rawBytes);
        }
        return new DirectHugeElement(IdGenerator.of(key), expiredTime);
    }

    public DirectHugeElement parseVertex(byte[] key, byte[] value) {
        long expiredTime = 0L;
        BytesBuffer buffer = BytesBuffer.wrap(value);
        buffer.readId();
        this.skipProperties(buffer);
        if (buffer.remaining() > 0) {
            expiredTime = buffer.readVLong();
        }
        return new DirectHugeElement(IdGenerator.of(key), expiredTime);
    }

    public DirectHugeElement parseEdge(byte[] key, byte[] value) {
        long expiredTime = 0L;
        BytesBuffer buffer = BytesBuffer.wrap(value);
        this.skipProperties(buffer);
        if (buffer.remaining() > 0) {
            expiredTime = buffer.readVLong();
        }
        return new DirectHugeElement(IdGenerator.of(key), expiredTime);
    }

    private void skipProperties(BytesBuffer buffer) {
        int size = buffer.readVInt();
        assert (size >= 0);
        for (int i = 0; i < size; ++i) {
            Id pkeyId = IdGenerator.of(buffer.readVInt());
            this.skipProperty(pkeyId, buffer);
        }
    }

    protected void skipProperty(Id pkeyId, BytesBuffer buffer) {
        PropertyKey pkey = new PropertyKey(null, pkeyId, "");
        buffer.readProperty(pkey);
    }

    public static class DirectHugeElement {
        private final Id id;
        private final long expiredTime;

        public DirectHugeElement(Id id, long expiredTime) {
            this.id = id;
            this.expiredTime = expiredTime;
        }

        public Id id() {
            return this.id;
        }

        public long expiredTime() {
            return this.expiredTime;
        }
    }
}

