/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.backend.BackendColumn;
import org.apache.hugegraph.backend.BinaryId;
import org.apache.hugegraph.exception.HugeException;
import org.apache.hugegraph.id.EdgeId;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdGenerator;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.struct.schema.EdgeLabel;
import org.apache.hugegraph.struct.schema.PropertyKey;
import org.apache.hugegraph.struct.schema.SchemaElement;
import org.apache.hugegraph.struct.schema.VertexLabel;
import org.apache.hugegraph.structure.BaseEdge;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseProperty;
import org.apache.hugegraph.structure.BaseVertex;
import org.apache.hugegraph.structure.Index;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Cardinality;
import org.apache.hugegraph.type.define.EdgeLabelType;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.slf4j.Logger;

public class BinaryElementSerializer {
    static final BinaryElementSerializer INSTANCE = new BinaryElementSerializer();
    static Logger log = Log.logger(BinaryElementSerializer.class);

    public static BinaryElementSerializer getInstance() {
        return INSTANCE;
    }

    public static Id ownerId(BaseElement element) {
        if (element instanceof BaseVertex) {
            return element.id();
        }
        if (element instanceof BaseEdge) {
            return ((EdgeId)element.id()).ownerVertexId();
        }
        throw new IllegalArgumentException("Only support get ownerid of BaseVertex or BaseEdge");
    }

    public static Id ownerId(Index index) {
        Id elementId = index.elementId();
        Id ownerId = null;
        ownerId = elementId instanceof EdgeId ? ((EdgeId)elementId).ownerVertexId() : elementId;
        return ownerId;
    }

    protected void parseProperty(HugeGraphSupplier graph, Id pkeyId, BytesBuffer buffer, BaseElement owner) {
        PropertyKey pkey = graph != null ? graph.propertyKey(pkeyId) : new PropertyKey(graph, pkeyId, "");
        Object value = buffer.readProperty(pkey);
        if (pkey.cardinality() == Cardinality.SINGLE) {
            owner.addProperty(pkey, value);
        } else {
            if (!(value instanceof Collection)) {
                throw new HugeException("Invalid value of non-single property: %s", value);
            }
            owner.addProperty(pkey, value);
        }
    }

    public void parseProperties(HugeGraphSupplier graph, BytesBuffer buffer, BaseElement owner) {
        int size = buffer.readVInt();
        assert (size >= 0);
        for (int i = 0; i < size; ++i) {
            Id pkeyId = IdGenerator.of(buffer.readVInt());
            this.parseProperty(graph, pkeyId, buffer, owner);
        }
    }

    public BaseVertex parseVertex(HugeGraphSupplier graph, BackendColumn vertexCol, BaseVertex vertex) {
        if (vertex == null) {
            BinaryId binaryId = BytesBuffer.wrap(vertexCol.name).parseId(HugeType.VERTEX);
            vertex = new BaseVertex(binaryId.origin(), VertexLabel.NONE);
        }
        if (ArrayUtils.isEmpty((byte[])vertexCol.value)) {
            return vertex;
        }
        BytesBuffer buffer = BytesBuffer.wrap(vertexCol.value);
        Id labelId = buffer.readId();
        if (graph != null) {
            VertexLabel label = graph.vertexLabelOrNone(labelId);
            vertex.correctVertexLabel(label);
        } else {
            VertexLabel label = new VertexLabel(null, labelId, "~undefined");
            vertex.correctVertexLabel(label);
        }
        this.parseProperties(graph, buffer, vertex);
        if (buffer.remaining() > 0) {
            this.parseExpiredTime(buffer, vertex);
        }
        return vertex;
    }

    public BaseVertex parseVertexOlap(HugeGraphSupplier graph, BackendColumn olapVertexCol, BaseVertex vertex) {
        if (vertex == null) {
            BytesBuffer idBuffer = BytesBuffer.wrap(olapVertexCol.name);
            idBuffer.readId();
            Id vertexId = idBuffer.readId();
            vertex = new BaseVertex(vertexId, VertexLabel.NONE);
        }
        BytesBuffer buffer = BytesBuffer.wrap(olapVertexCol.value);
        Id pkeyId = IdGenerator.of(buffer.readVInt());
        this.parseProperty(graph, pkeyId, buffer, vertex);
        return vertex;
    }

    public BaseVertex parseVertexFromCols(HugeGraphSupplier graph, BackendColumn ... cols) {
        assert (cols.length > 0);
        BaseVertex vertex = null;
        for (int index = 0; index < cols.length; ++index) {
            BackendColumn col = cols[index];
            if (index == 0) {
                vertex = this.parseVertex(graph, col, vertex);
                continue;
            }
            this.parseVertexOlap(graph, col, vertex);
        }
        return vertex;
    }

    public Id parseLabelFromCol(BackendColumn col, boolean isVertex) {
        BytesBuffer buffer;
        if (isVertex) {
            buffer = BytesBuffer.wrap(col.value);
        } else {
            buffer = BytesBuffer.wrap(col.name);
            Id ownerVertexId = buffer.readId();
            E.checkState((buffer.remaining() > 0 ? 1 : 0) != 0, (String)"Missing column type", (Object[])new Object[0]);
            byte type = buffer.read();
            Id id = buffer.readId();
        }
        return buffer.readId();
    }

    public BaseEdge parseEdge(HugeGraphSupplier graph, BackendColumn edgeCol, BaseVertex ownerVertex, boolean withEdgeProperties) {
        EdgeLabel edgeLabel;
        BytesBuffer buffer = BytesBuffer.wrap(edgeCol.name);
        Id id = buffer.readId();
        if (ownerVertex == null) {
            ownerVertex = new BaseVertex(id, VertexLabel.NONE);
        }
        E.checkState((buffer.remaining() > 0 ? 1 : 0) != 0, (String)"Missing column type", (Object[])new Object[0]);
        byte type = buffer.read();
        if (type == HugeType.EDGE_IN.code() || type == HugeType.EDGE_OUT.code()) {
            E.checkState((boolean)true, (String)"Invalid column(%s) with unknown type(%s): 0x%s", (Object[])new Object[]{id, type & 0xFF, Bytes.toHex((byte[])edgeCol.name)});
        }
        Id labelId = buffer.readId();
        Id subLabelId = buffer.readId();
        String sortValues = buffer.readStringWithEnding();
        Id otherVertexId = buffer.readId();
        boolean direction = EdgeId.isOutDirectionFromCode(type);
        if (graph == null) {
            edgeLabel = new EdgeLabel(null, subLabelId, "~undefined");
            if (subLabelId != labelId) {
                edgeLabel.edgeLabelType(EdgeLabelType.SUB);
                edgeLabel.fatherId(labelId);
            }
        } else {
            edgeLabel = graph.edgeLabelOrNone(subLabelId);
        }
        BaseEdge edge = BaseEdge.constructEdge(graph, ownerVertex, direction, edgeLabel, sortValues, otherVertexId);
        if (!withEdgeProperties) {
            return edge;
        }
        if (ArrayUtils.isEmpty((byte[])edgeCol.value)) {
            return edge;
        }
        buffer = BytesBuffer.wrap(edgeCol.value);
        this.parseProperties(graph, buffer, edge);
        if (buffer.remaining() > 0) {
            this.parseExpiredTime(buffer, edge);
        }
        return edge;
    }

    public Index parseIndex(HugeGraphSupplier graph, BackendColumn indexCol, Index index) {
        HugeType indexType = this.parseIndexType(indexCol);
        BytesBuffer buffer = BytesBuffer.wrap(indexCol.name);
        BinaryId indexId = buffer.readIndexId(indexType);
        Id elemId = buffer.readId();
        if (index == null) {
            index = Index.parseIndexId(graph, indexType, indexId.asBytes());
        }
        long expiredTime = 0L;
        if (indexCol.value.length > 0) {
            int delimiterIndex = Bytes.indexOf((byte[])indexCol.value, (byte)0);
            if (delimiterIndex >= 0) {
                byte[] rawBytes;
                byte[] expiredTimeBytes;
                byte[] fieldValueBytes = Arrays.copyOfRange(indexCol.value, 0, delimiterIndex);
                if (fieldValueBytes.length > 0) {
                    index.fieldValues(StringEncoding.decode(fieldValueBytes));
                }
                if ((expiredTimeBytes = Arrays.copyOfRange(indexCol.value, delimiterIndex + 1, indexCol.value.length)).length > 0 && (rawBytes = Base64.getDecoder().decode(expiredTimeBytes)).length >= 8) {
                    expiredTime = Longs.fromByteArray((byte[])rawBytes);
                }
            } else {
                index.fieldValues(StringEncoding.decode(indexCol.value));
            }
        }
        index.elementIds(elemId, expiredTime);
        return index;
    }

    public BackendColumn parseIndex(BackendColumn indexCol) {
        throw new NotImplementedException("BinaryElementSerializer.parseIndex");
    }

    public BackendColumn writeVertex(BaseVertex vertex) {
        if (vertex.olap()) {
            return this.writeOlapVertex(vertex);
        }
        BytesBuffer bufferName = BytesBuffer.allocate(vertex.id().length());
        bufferName.writeId(vertex.id());
        int propsCount = vertex.getProperties().size();
        BytesBuffer buffer = BytesBuffer.allocate(8 + 16 * propsCount);
        buffer.writeId(vertex.schemaLabel().id());
        this.formatProperties(vertex.getProperties().values(), buffer);
        if (vertex.hasTtl()) {
            this.formatExpiredTime(vertex.expiredTime(), buffer);
        }
        return BackendColumn.of(bufferName.bytes(), buffer.bytes());
    }

    public BackendColumn writeOlapVertex(BaseVertex vertex) {
        BytesBuffer buffer = BytesBuffer.allocate(24);
        BaseProperty<?> baseProperty = vertex.getProperties().values().iterator().next();
        PropertyKey propertyKey = baseProperty.propertyKey();
        buffer.writeVInt(SchemaElement.schemaId(propertyKey.id()));
        buffer.writeProperty(propertyKey.cardinality(), propertyKey.dataType(), baseProperty.value());
        BytesBuffer bufferName = BytesBuffer.allocate(1 + propertyKey.id().length() + 1 + vertex.id().length());
        bufferName.writeId(propertyKey.id());
        bufferName.writeId(vertex.id()).bytes();
        return BackendColumn.of(bufferName.bytes(), buffer.bytes());
    }

    public BackendColumn writeEdge(BaseEdge edge) {
        byte[] name = this.formatEdgeName(edge);
        byte[] value = this.formatEdgeValue(edge);
        return BackendColumn.of(name, value);
    }

    public BackendColumn writeIndex(Index index) {
        return BackendColumn.of(this.formatIndexName(index), this.formatIndexValue(index));
    }

    private byte[] formatIndexName(Index index) {
        Id elemId = index.elementId();
        Id indexId = index.id();
        HugeType type = index.type();
        int idLen = 1 + elemId.length() + 1 + indexId.length();
        BytesBuffer buffer = BytesBuffer.allocate(idLen);
        buffer.writeIndexId(indexId, type);
        buffer.writeId(elemId);
        return buffer.bytes();
    }

    private byte[] formatIndexValue(Index index) {
        if (index.hasTtl()) {
            BytesBuffer valueBuffer = BytesBuffer.allocate(14);
            valueBuffer.write((byte)0);
            byte[] ttlBytes = Base64.getEncoder().encode(Longs.toByteArray((long)index.expiredTime()));
            valueBuffer.write(ttlBytes);
            return valueBuffer.bytes();
        }
        return null;
    }

    public BackendColumn mergeCols(BackendColumn vertexCol, BackendColumn ... olapVertexCols) {
        if (olapVertexCols.length == 0) {
            return vertexCol;
        }
        BytesBuffer mergedBuffer = BytesBuffer.allocate(vertexCol.value.length + olapVertexCols.length * 16);
        BytesBuffer buffer = BytesBuffer.wrap(vertexCol.value);
        Id vl = buffer.readId();
        int size = buffer.readVInt();
        mergedBuffer.writeId(vl);
        mergedBuffer.writeVInt(size + olapVertexCols.length);
        for (BackendColumn olapVertexCol : olapVertexCols) {
            mergedBuffer.write(olapVertexCol.value);
        }
        mergedBuffer.write(buffer.remainingBytes());
        return BackendColumn.of(vertexCol.name, mergedBuffer.bytes());
    }

    public BaseElement index2Element(HugeGraphSupplier graph, BackendColumn indexCol) {
        throw new NotImplementedException("BinaryElementSerializer.index2Element");
    }

    public byte[] formatEdgeName(BaseEdge edge) {
        return BytesBuffer.allocate(128).writeEdgeId(edge.id()).bytes();
    }

    protected byte[] formatEdgeValue(BaseEdge edge) {
        Map<Id, BaseProperty<?>> properties = edge.getProperties();
        int propsCount = properties.size();
        BytesBuffer buffer = BytesBuffer.allocate(4 + 16 * propsCount);
        this.formatProperties(properties.values(), buffer);
        if (edge.hasTtl()) {
            this.formatExpiredTime(edge.expiredTime(), buffer);
        }
        return buffer.bytes();
    }

    public void formatProperties(Collection<BaseProperty<?>> props, BytesBuffer buffer) {
        buffer.writeVInt(props.size());
        for (BaseProperty<?> property : props) {
            PropertyKey pkey = property.propertyKey();
            buffer.writeVInt(SchemaElement.schemaId(pkey.id()));
            buffer.writeProperty(pkey.cardinality(), pkey.dataType(), property.value());
        }
    }

    public void formatExpiredTime(long expiredTime, BytesBuffer buffer) {
        buffer.writeVLong(expiredTime);
    }

    protected void parseExpiredTime(BytesBuffer buffer, BaseElement element) {
        element.expiredTime(buffer.readVLong());
    }

    private HugeType parseIndexType(BackendColumn col) {
        byte first = col.name[0];
        byte second = col.name[1];
        if (first < 0) {
            return HugeType.fromCode(first);
        }
        assert (second >= 0);
        String type = new String(new byte[]{first, second});
        return HugeType.fromString(type);
    }
}

