/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend;

import java.util.Arrays;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.StringEncoding;

public class BackendColumn
implements Comparable<BackendColumn> {
    public byte[] name;
    public byte[] value;

    public static BackendColumn of(byte[] name, byte[] value) {
        BackendColumn col = new BackendColumn();
        col.name = name;
        col.value = value;
        return col;
    }

    public String toString() {
        return String.format("%s=%s", StringEncoding.decode(this.name), StringEncoding.decode(this.value));
    }

    @Override
    public int compareTo(BackendColumn other) {
        if (other == null) {
            return 1;
        }
        return Bytes.compare((byte[])this.name, (byte[])other.name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BackendColumn)) {
            return false;
        }
        BackendColumn other = (BackendColumn)obj;
        return Bytes.equals((byte[])this.name, (byte[])other.name) && Bytes.equals((byte[])this.value, (byte[])other.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.name) | Arrays.hashCode(this.value);
    }
}

