/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import com.google.common.collect.RangeMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.common.GraphCache;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.common.PartitionUtils;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCache {
    private static final Logger log = LoggerFactory.getLogger(ClientCache.class);
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private PDClient client;
    private volatile Map<Integer, KVPair<Metapb.ShardGroup, Metapb.Shard>> groups;
    private volatile Map<Long, Metapb.Store> stores;
    private volatile Map<String, GraphCache> caches = new ConcurrentHashMap<String, GraphCache>();

    public ClientCache(PDClient pdClient) {
        this.groups = new ConcurrentHashMap<Integer, KVPair<Metapb.ShardGroup, Metapb.Shard>>();
        this.stores = new ConcurrentHashMap<Long, Metapb.Store>();
        this.client = pdClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphCache getGraphCache(String graphName) {
        GraphCache graph = this.caches.get(graphName);
        if (graph == null) {
            Map<String, GraphCache> map = this.caches;
            synchronized (map) {
                graph = this.caches.get(graphName);
                if (graph == null) {
                    Metapb.Graph.Builder builder = Metapb.Graph.newBuilder().setGraphName(graphName);
                    Metapb.Graph g = builder.build();
                    graph = new GraphCache(g);
                    this.caches.put(graphName, graph);
                }
            }
        }
        return graph;
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionById(String graphName, int partId) {
        try {
            GraphCache graph = this.initGraph(graphName);
            Metapb.Partition partition = graph.getPartition(Integer.valueOf(partId));
            if (partition == null) {
                return null;
            }
            KVPair<Metapb.ShardGroup, Metapb.Shard> group = this.groups.get(partId);
            if (group == null) {
                return null;
            }
            Metapb.Shard shard = (Metapb.Shard)group.getValue();
            if (shard == null) {
                return null;
            }
            return new KVPair((Object)partition, (Object)shard);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KVPair<Metapb.Partition, Metapb.Shard> getPair(int partId, GraphCache graph) {
        Metapb.Partition p = graph.getPartition(Integer.valueOf(partId));
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(partId);
        if (p != null && pair != null) {
            Metapb.Shard s = (Metapb.Shard)pair.getValue();
            if (s == null) {
                pair.setValue((Object)this.getLeader(partId));
                return new KVPair((Object)p, (Object)((Metapb.Shard)pair.getValue()));
            }
            return new KVPair((Object)p, (Object)s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionByCode(String graphName, long code) {
        try {
            GraphCache graph = this.initGraph(graphName);
            RangeMap range = graph.getRange();
            Integer pId = (Integer)range.get((Comparable)Long.valueOf(code));
            if (pId != null) {
                return this.getPair(pId, graph);
            }
            ReentrantReadWriteLock.ReadLock readLock = graph.getLock().readLock();
            try {
                readLock.lock();
                pId = (Integer)range.get((Comparable)Long.valueOf(code));
            }
            catch (Exception e) {
                log.info("get range with error:", (Throwable)e);
            }
            finally {
                readLock.unlock();
            }
            if (pId == null) {
                ReentrantReadWriteLock.WriteLock writeLock = graph.getLock().writeLock();
                try {
                    writeLock.lock();
                    pId = (Integer)range.get((Comparable)Long.valueOf(code));
                    if (pId == null) {
                        graph.reset();
                        this.initGraph(graph);
                        pId = (Integer)range.get((Comparable)Long.valueOf(code));
                    }
                }
                catch (Exception e) {
                    log.info("reset with error:", (Throwable)e);
                }
                finally {
                    writeLock.unlock();
                }
            }
            if (pId != null) {
                return this.getPair(pId, graph);
            }
            return null;
        }
        catch (PDException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphCache initGraph(String graphName) throws PDException {
        this.initCache();
        GraphCache graph = this.getGraphCache(graphName);
        if (!graph.getInitialized().get()) {
            GraphCache graphCache = graph;
            synchronized (graphCache) {
                if (!graph.getInitialized().get()) {
                    this.initGraph(graph);
                    graph.getInitialized().set(true);
                }
            }
        }
        return graph;
    }

    private void initGraph(GraphCache graph) throws PDException {
        Pdpb.CachePartitionResponse pc = this.client.getPartitionCache(graph.getGraph().getGraphName());
        List ps = pc.getPartitionsList();
        if (!CollectionUtils.isEmpty((Collection)ps)) {
            graph.init(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCache() throws PDException {
        if (!this.initialized.get()) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                if (!this.initialized.get()) {
                    Pdpb.CacheResponse cache = this.client.getClientCache();
                    List shardGroups = cache.getShardsList();
                    for (Object s : shardGroups) {
                        this.groups.put(s.getId(), (KVPair<Metapb.ShardGroup, Metapb.Shard>)new KVPair(s, (Object)this.getLeader((Metapb.ShardGroup)s)));
                    }
                    List stores = cache.getStoresList();
                    for (Metapb.Store store : stores) {
                        this.stores.put(store.getId(), store);
                    }
                    List graphs = cache.getGraphsList();
                    for (Metapb.Graph g : graphs) {
                        GraphCache c = new GraphCache(g);
                        this.caches.put(g.getGraphName(), c);
                    }
                    this.initialized.set(true);
                }
            }
        }
    }

    public KVPair<Metapb.Partition, Metapb.Shard> getPartitionByKey(String graphName, byte[] key) {
        int code = PartitionUtils.calcHashcode((byte[])key);
        return this.getPartitionByCode(graphName, code);
    }

    public boolean update(String graphName, int partId, Metapb.Partition partition) {
        GraphCache graph = this.getGraphCache(graphName);
        return graph.updatePartition(partition);
    }

    public void removePartition(String graphName, int partId) {
        GraphCache graph = this.getGraphCache(graphName);
        graph.removePartition(Integer.valueOf(partId));
    }

    public void removePartitions() {
        try {
            this.groups.clear();
            this.stores.clear();
            this.caches.clear();
            this.initialized.set(false);
            this.initCache();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void removePartitions(GraphCache graph) {
        try {
            graph.removePartitions();
            this.initGraph(graph.getGraph().getGraphName());
        }
        catch (Exception e) {
            log.warn("remove partitions with error:", (Throwable)e);
        }
    }

    public void removeAll(String graphName) {
        GraphCache graph = this.caches.get(graphName);
        if (graph != null) {
            this.removePartitions(graph);
        }
    }

    private StringBuffer getStack(StackTraceElement[] stackTrace) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            sb.append(element.toString() + "\n");
        }
        return sb;
    }

    public boolean updateShardGroup(Metapb.ShardGroup shardGroup) {
        KVPair<Metapb.ShardGroup, Metapb.Shard> old = this.groups.get(shardGroup.getId());
        Metapb.Shard leader = this.getLeader(shardGroup);
        if (old != null) {
            old.setKey((Object)shardGroup);
            old.setValue((Object)leader);
            return false;
        }
        this.groups.put(shardGroup.getId(), (KVPair<Metapb.ShardGroup, Metapb.Shard>)new KVPair((Object)shardGroup, (Object)leader));
        return true;
    }

    public void deleteShardGroup(int shardGroupId) {
        this.groups.remove(shardGroupId);
    }

    public Metapb.ShardGroup getShardGroup(int groupId) {
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(groupId);
        if (pair != null) {
            return (Metapb.ShardGroup)pair.getKey();
        }
        return null;
    }

    public boolean addStore(Long storeId, Metapb.Store store) {
        Metapb.Store oldStore = this.stores.get(storeId);
        if (oldStore != null && oldStore.equals((Object)store)) {
            return false;
        }
        this.stores.put(storeId, store);
        return true;
    }

    public Metapb.Store getStoreById(Long storeId) {
        return this.stores.get(storeId);
    }

    public void removeStore(Long storeId) {
        this.stores.remove(storeId);
    }

    public void reset() {
        this.groups = new ConcurrentHashMap<Integer, KVPair<Metapb.ShardGroup, Metapb.Shard>>();
        this.stores = new ConcurrentHashMap<Long, Metapb.Store>();
        this.caches = new ConcurrentHashMap<String, GraphCache>();
        this.initialized.set(false);
    }

    public Metapb.Shard getLeader(int partitionId) {
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(partitionId);
        if (pair != null) {
            if (pair.getValue() != null) {
                return (Metapb.Shard)pair.getValue();
            }
            for (Metapb.Shard shard : ((Metapb.ShardGroup)pair.getKey()).getShardsList()) {
                if (shard.getRole() != Metapb.ShardRole.Leader) continue;
                pair.setValue((Object)shard);
                return shard;
            }
        }
        return null;
    }

    public Metapb.Shard getLeader(Metapb.ShardGroup shardGroup) {
        if (shardGroup != null) {
            for (Metapb.Shard shard : shardGroup.getShardsList()) {
                if (shard.getRole() != Metapb.ShardRole.Leader) continue;
                return shard;
            }
        }
        return null;
    }

    public void updateLeader(int partitionId, Metapb.Shard leader) {
        Metapb.Shard l;
        KVPair<Metapb.ShardGroup, Metapb.Shard> pair = this.groups.get(partitionId);
        if (pair != null && leader != null && ((l = this.getLeader(partitionId)) == null || leader.getStoreId() != l.getStoreId())) {
            Metapb.ShardGroup shardGroup = (Metapb.ShardGroup)pair.getKey();
            Metapb.ShardGroup.Builder builder = Metapb.ShardGroup.newBuilder((Metapb.ShardGroup)shardGroup).clearShards();
            for (Metapb.Shard shard : shardGroup.getShardsList()) {
                builder.addShards(Metapb.Shard.newBuilder().setStoreId(shard.getStoreId()).setRole(shard.getStoreId() == leader.getStoreId() ? Metapb.ShardRole.Leader : Metapb.ShardRole.Follower).build());
            }
            pair.setKey((Object)builder.build());
            pair.setValue((Object)leader);
        }
    }

    public List<String> getLeaderStoreAddresses() throws PDException {
        this.initCache();
        Set storeIds = this.groups.values().stream().map(KVPair::getValue).filter(Objects::nonNull).map(Metapb.Shard::getStoreId).collect(Collectors.toSet());
        return this.stores.values().stream().filter(store -> storeIds.contains(store.getId())).map(Metapb.Store::getAddress).collect(Collectors.toList());
    }

    public Map<Integer, String> getLeaderPartitionStoreAddress(String graphName) throws PDException {
        this.initCache();
        return this.groups.values().stream().collect(Collectors.toMap(pair -> ((Metapb.ShardGroup)pair.getKey()).getId(), pair -> this.stores.get(((Metapb.Shard)pair.getValue()).getStoreId()).getAddress()));
    }
}

