/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation.walker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.opencypher.gremlin.translation.GremlinPredicates;
import org.opencypher.gremlin.translation.GremlinSteps;
import org.opencypher.gremlin.translation.context.WalkerContext;
import org.opencypher.gremlin.translation.exception.CypherExceptions;
import org.opencypher.gremlin.translation.walker.ExpressionWalker$;
import org.opencypher.gremlin.traversal.CustomFunction;
import org.opencypher.v9_0.expressions.AnonymousPatternPart;
import org.opencypher.v9_0.expressions.DecimalDoubleLiteral;
import org.opencypher.v9_0.expressions.EveryPath;
import org.opencypher.v9_0.expressions.Expression;
import org.opencypher.v9_0.expressions.False;
import org.opencypher.v9_0.expressions.FunctionInvocation;
import org.opencypher.v9_0.expressions.FunctionName;
import org.opencypher.v9_0.expressions.ListComprehension;
import org.opencypher.v9_0.expressions.ListLiteral;
import org.opencypher.v9_0.expressions.Literal;
import org.opencypher.v9_0.expressions.LogicalVariable;
import org.opencypher.v9_0.expressions.LogicalVariable$;
import org.opencypher.v9_0.expressions.MapExpression;
import org.opencypher.v9_0.expressions.NamedPatternPart;
import org.opencypher.v9_0.expressions.NodePattern;
import org.opencypher.v9_0.expressions.Null;
import org.opencypher.v9_0.expressions.Parameter;
import org.opencypher.v9_0.expressions.PatternElement;
import org.opencypher.v9_0.expressions.PatternPart;
import org.opencypher.v9_0.expressions.RelationshipChain;
import org.opencypher.v9_0.expressions.RelationshipPattern;
import org.opencypher.v9_0.expressions.SignedDecimalIntegerLiteral;
import org.opencypher.v9_0.expressions.StringLiteral;
import org.opencypher.v9_0.expressions.True;
import org.opencypher.v9_0.expressions.Variable;
import org.opencypher.v9_0.util.ASTNode;
import org.opencypher.v9_0.util.InputPosition$;
import org.opencypher.v9_0.util.symbols.AnyType;
import org.opencypher.v9_0.util.symbols.AnyType$;
import org.opencypher.v9_0.util.symbols.CypherType;
import org.opencypher.v9_0.util.symbols.ListType;
import org.opencypher.v9_0.util.symbols.NodeType;
import org.opencypher.v9_0.util.symbols.RelationshipType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NodeUtils$ {
    public static NodeUtils$ MODULE$;

    static {
        new NodeUtils$();
    }

    public <T, P> Object expressionValue(Expression node, WalkerContext<T, P> context) {
        return this.traversalValueToJava(node, context, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)name -> context.parameter((String)name));
    }

    public <T, P> Object inlineExpressionValue(Expression node, WalkerContext<T, P> context) {
        return this.inlineExpressionValue(node, context, Object.class);
    }

    public <T, P, R> R inlineExpressionValue(Expression node, WalkerContext<T, P> context, Class<R> klass) {
        Function1 & Serializable & scala.Serializable parameterHandler = (Function1 & Serializable & scala.Serializable)name -> context.inlineParameter((String)name, klass);
        return (R)this.traversalValueToJava(node, context, (Function1<String, Object>)parameterHandler);
    }

    public <T, P> Object traversalValueToJava(Object value, WalkerContext<T, P> context, Function1<String, Object> parameterHandler) {
        Object javaValue;
        Option<Object> option = this.traversalValueOption(value, context, parameterHandler);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw context.unsupported("value expression", value);
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Object object = javaValue = some.value();
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, P> Option<Object> traversalValueOption(Object value, WalkerContext<T, P> context, Function1<String, Object> parameterHandler) {
        ListComprehension listComprehension;
        Expression expression;
        Object object = value;
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            String varName = variable.name();
            return new Option<Object>((Object)varName);
        }
        if (object instanceof Parameter) {
            Parameter parameter = (Parameter)object;
            String name = parameter.name();
            return new Some(parameterHandler.apply((Object)name));
        }
        if (object instanceof Null) {
            return new Some((Object)"  cypher.null");
        }
        if (object instanceof ListComprehension && (expression = (listComprehension = (ListComprehension)object).expression()) instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            String name = parameter.name();
            return new Some(parameterHandler.apply((Object)name));
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            return new Some(literal.value());
        }
        if (object instanceof ListLiteral) {
            ListLiteral listLiteral = (ListLiteral)object;
            Seq expressions = listLiteral.expressions();
            return new Some(this.traversalValueToJava(expressions, context, parameterHandler));
        }
        if (object instanceof MapExpression) {
            MapExpression mapExpression = (MapExpression)object;
            Seq items = mapExpression.items();
            return new Some(this.traversalValueToJava(items.toMap(Predef$.MODULE$.$conforms()), context, parameterHandler));
        }
        if (object instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)object;
            FunctionName functionName = functionInvocation.functionName();
            IndexedSeq indexedSeq = functionInvocation.args();
            if (functionName != null) {
                String fnName = functionName.name();
                Some some = Seq$.MODULE$.unapplySeq((Seq)indexedSeq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    Expression arg = (Expression)((SeqLike)some.get()).apply(0);
                    return this.inlineFunction(fnName, this.traversalValueOption(arg, context, parameterHandler));
                }
            }
        }
        if (object instanceof Seq) {
            Seq seq = (Seq)object;
            Seq mappedSeq = (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.traversalValueToJava(x$1, context, parameterHandler), Seq$.MODULE$.canBuildFrom());
            return new Some(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(mappedSeq).asJava()));
        }
        if (!(object instanceof scala.collection.immutable.Map)) return None$.MODULE$;
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
        scala.collection.immutable.Map mappedMap = map.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.traversalValueToJava(x$2, context, parameterHandler));
        return new Some(new LinkedHashMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)mappedMap).asJava()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Object> inlineFunction(String name, Option<Object> arg) {
        Tuple2 tuple2 = new Tuple2((Object)name, arg);
        if (tuple2 != null) {
            Some some;
            Object n;
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("abs".equals(string) && option instanceof Some && (n = (some = (Some)option).value()) instanceof Double) {
                Double d = (Double)n;
                return new Some((Object)BoxesRunTime.boxToDouble((double)Math.abs(Predef$.MODULE$.Double2double(d))));
            }
        }
        if (tuple2 != null) {
            Some some;
            Object n;
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("ceil".equals(string) && option instanceof Some && (n = (some = (Some)option).value()) instanceof Double) {
                Double d = (Double)n;
                return new Some((Object)BoxesRunTime.boxToDouble((double)Math.ceil(Predef$.MODULE$.Double2double(d))));
            }
        }
        if (tuple2 != null) {
            Some some;
            Object n;
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("sqrt".equals(string) && option instanceof Some && (n = (some = (Some)option).value()) instanceof Double) {
                Double d = (Double)n;
                return new Some((Object)BoxesRunTime.boxToDouble((double)Math.sqrt(Predef$.MODULE$.Double2double(d))));
            }
        }
        if (tuple2 != null) {
            Some some;
            Object n;
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("toInteger".equals(string) && option instanceof Some && (n = (some = (Some)option).value()) instanceof Number) {
                Number number = (Number)n;
                return new Some((Object)BoxesRunTime.boxToInteger((int)number.intValue()));
            }
        }
        if (tuple2 != null) {
            Some some;
            Object n;
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("toInteger".equals(string) && option instanceof Some && (n = (some = (Some)option).value()) instanceof String) {
                String string2 = (String)n;
                return new Some((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt(string2)));
            }
        }
        if (tuple2 != null) {
            Some some;
            Object n;
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("toFloat".equals(string) && option instanceof Some && (n = (some = (Some)option).value()) instanceof Number) {
                Number number = (Number)n;
                return new Some((Object)BoxesRunTime.boxToFloat((float)number.floatValue()));
            }
        }
        if (tuple2 != null) {
            Some some;
            Object n;
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("toFloat".equals(string) && option instanceof Some && (n = (some = (Some)option).value()) instanceof String) {
                String string3 = (String)n;
                return new Some((Object)BoxesRunTime.boxToFloat((float)Float.parseFloat(string3)));
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if ("toString".equals(string) && option instanceof Some) {
                Some some = (Some)option;
                Object n = some.value();
                return new Some((Object)n.toString());
            }
        }
        if (tuple2 == null) return None$.MODULE$;
        String string = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!"toBoolean".equals(string)) return None$.MODULE$;
        if (!(option instanceof Some)) return None$.MODULE$;
        Some some = (Some)option;
        Object n = some.value();
        if (!(n instanceof String)) return None$.MODULE$;
        String string4 = (String)n;
        return new Some((Object)Boolean.valueOf(string4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector<String> getPathTraversalAliases(PatternPart patternPart) {
        PatternPart patternPart2 = patternPart;
        if (!(patternPart2 instanceof NamedPatternPart)) return this.getPathTraversalAliases(patternPart.element());
        NamedPatternPart namedPatternPart = (NamedPatternPart)patternPart2;
        Variable variable = namedPatternPart.variable();
        AnonymousPatternPart anonymousPatternPart = namedPatternPart.patternPart();
        if (variable == null) return this.getPathTraversalAliases(patternPart.element());
        String pathName = variable.name();
        if (!(anonymousPatternPart instanceof EveryPath)) return this.getPathTraversalAliases(patternPart.element());
        EveryPath everyPath = (EveryPath)anonymousPatternPart;
        PatternElement patternElement = everyPath.element();
        return (Vector)this.getPathTraversalAliases(patternElement).$colon$plus((Object)pathName, Vector$.MODULE$.canBuildFrom());
    }

    public Vector<String> getPathTraversalAliases(PatternElement patternElement) {
        return (Vector)this.flattenRelationshipChain((ASTNode)patternElement).foldLeft((Object)package$.MODULE$.Vector().empty(), (Function2 & Serializable & scala.Serializable)(acc, element) -> {
            Some some;
            LogicalVariable logicalVariable;
            RelationshipPattern relationshipPattern;
            Option option;
            Vector vector;
            Some some2;
            LogicalVariable logicalVariable2;
            NodePattern nodePattern;
            Option option2;
            ASTNode aSTNode = element;
            if (aSTNode instanceof NodePattern && (option2 = (nodePattern = (NodePattern)aSTNode).variable()) instanceof Some && (logicalVariable2 = (LogicalVariable)(some2 = (Some)option2).value()) instanceof Variable) {
                Variable variable = (Variable)logicalVariable2;
                String name = variable.name();
                vector = (Vector)acc.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom());
            } else if (aSTNode instanceof RelationshipPattern && (option = (relationshipPattern = (RelationshipPattern)aSTNode).variable()) instanceof Some && (logicalVariable = (LogicalVariable)(some = (Some)option).value()) instanceof Variable) {
                Variable variable = (Variable)logicalVariable;
                String name = variable.name();
                vector = (Vector)acc.$colon$plus((Object)name, Vector$.MODULE$.canBuildFrom());
            } else {
                vector = acc;
            }
            return vector;
        });
    }

    public Vector<ASTNode> flattenRelationshipChain(ASTNode node) {
        return this.flattenRelationshipChain((Vector<ASTNode>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), node);
    }

    private Vector<ASTNode> flattenRelationshipChain(Vector<ASTNode> acc, ASTNode node) {
        Vector vector;
        ASTNode aSTNode = node;
        if (aSTNode instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)aSTNode;
            PatternElement left = relationshipChain.element();
            RelationshipPattern relationship = relationshipChain.relationship();
            NodePattern right = relationshipChain.rightNode();
            vector = (Vector)((Vector)((Vector)acc.$plus$plus(this.flattenRelationshipChain((Vector<ASTNode>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), (ASTNode)left), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelationshipPattern[]{relationship})), Vector$.MODULE$.canBuildFrom())).$plus$plus(this.flattenRelationshipChain((Vector<ASTNode>)((Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$)), (ASTNode)right), Vector$.MODULE$.canBuildFrom());
        } else {
            vector = (Vector)acc.$colon$plus((Object)aSTNode, Vector$.MODULE$.canBuildFrom());
        }
        return vector;
    }

    public <T, P> GremlinSteps<T, P> asUniqueName(String name, GremlinSteps<T, P> g, WalkerContext<T, P> context) {
        GremlinSteps<T, Object> gremlinSteps;
        GremlinPredicates<P> p = context.dsl().predicates();
        Option<String> option = context.alias(name);
        if (option instanceof Some) {
            Some some = (Some)option;
            String generated = (String)some.value();
            gremlinSteps = g.as(generated).where(g.start().select(generated).where(p.isEq(name)));
        } else {
            gremlinSteps = g.as(name);
        }
        return gremlinSteps;
    }

    public <T, P> GremlinSteps<T, P> notNull(GremlinSteps<T, P> traversal, WalkerContext<T, P> context) {
        GremlinSteps<T, P> g = context.dsl().steps();
        GremlinPredicates<P> p = context.dsl().predicates();
        return g.start().choose(p.neq("  cypher.null"), traversal);
    }

    public <T, P> GremlinSteps<T, P> emptyToNull(GremlinSteps<T, P> traversal, WalkerContext<T, P> context) {
        GremlinSteps<T, P> g = context.dsl().steps();
        return g.start().choose(traversal, (GremlinSteps<T, GremlinSteps<T, P>>)traversal, (GremlinSteps<T, GremlinSteps<T, P>>)g.start().constant("  cypher.null"));
    }

    public <T, P> GremlinSteps<T, P> asList(Seq<Expression> expressions, WalkerContext<T, P> context) {
        GremlinSteps g = context.dsl().steps();
        if (expressions.isEmpty()) {
            return g.start().constant(new ArrayList());
        }
        Seq keys = (Seq)expressions.map((Function1 & Serializable & scala.Serializable)x$3 -> context.generateName(), Seq$.MODULE$.canBuildFrom());
        GremlinSteps traversal2 = g.start().project((String[])keys.toArray(ClassTag$.MODULE$.apply(String.class)));
        ((IterableLike)expressions.map((Function1 & Serializable & scala.Serializable)x$4 -> ExpressionWalker$.MODULE$.walkLocal(context, g, (Expression)x$4, ExpressionWalker$.MODULE$.walkLocal$default$4()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)traversal -> traversal2.by((GremlinSteps)traversal));
        return traversal2.select(Column.values);
    }

    public <T, P> void ensureFirstStatement(GremlinSteps<T, P> traversal, WalkerContext<T, P> context) {
        block0: {
            if (!context.isFirstStatement()) break block0;
            traversal.inject("  cypher.start");
            context.markFirstStatement();
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T, P> GremlinSteps<T, P> selectNestedAliases(Seq<String> keys, WalkerContext<T, P> context) {
        void var3_3;
        GremlinSteps g = context.dsl().steps().start();
        String mapName = context.generateName();
        g.as(mapName);
        ((TraversableLike)keys.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)NodeUtils$.$anonfun$selectNestedAliases$1(context, x$5)))).map((Function1 & Serializable & scala.Serializable)alias -> g.select(mapName).select((String)alias).as((String)alias), Seq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public <T, P> GremlinSteps<T, P> reselectProjection(Seq<LogicalVariable> items, WalkerContext<T, P> context) {
        void var3_3;
        GremlinSteps traversal = context.dsl().steps().start();
        String name = context.generateName();
        Object object = items.lengthCompare(1) > 0 ? traversal.as(name) : BoxedUnit.UNIT;
        ((Stream)items.toStream().zipWithIndex(Stream$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return BoxedUnit.UNIT;
            LogicalVariable logicalVariable = (LogicalVariable)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (!(logicalVariable instanceof Variable)) return BoxedUnit.UNIT;
            Variable variable = (Variable)logicalVariable;
            Option option = LogicalVariable$.MODULE$.unapply(variable);
            if (option.isEmpty()) return BoxedUnit.UNIT;
            String alias = (String)option.get();
            Object object = i > 0 ? traversal.select(name) : BoxedUnit.UNIT;
            traversal.select(alias).as(alias);
            return context.alias(alias);
        });
        return var3_3;
    }

    public <T, P> GremlinSteps<T, P> setProperty(GremlinSteps<T, P> traversal, CypherType cypherType, String key, GremlinSteps<T, P> value) {
        GremlinSteps<T, P> gremlinSteps;
        CypherType cypherType2 = cypherType;
        if (cypherType2 instanceof NodeType) {
            gremlinSteps = traversal.property(VertexProperty.Cardinality.single, key, value);
        } else if (cypherType2 instanceof RelationshipType) {
            gremlinSteps = traversal.property(key, value);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(27).append("Unsupported property type: ").append(cypherType).toString());
        }
        return gremlinSteps;
    }

    public ListLiteral toListLiteral(Iterable<?> obj) {
        return new ListLiteral(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(obj).asScala()).map((Function1 & Serializable & scala.Serializable)el -> MODULE$.toLiteral(el), Iterable$.MODULE$.canBuildFrom())).toSeq(), InputPosition$.MODULE$.NONE());
    }

    public Literal toLiteral(Object obj) {
        SignedDecimalIntegerLiteral signedDecimalIntegerLiteral;
        Object object = obj;
        boolean bl = object instanceof Integer ? true : object instanceof Long;
        if (bl) {
            signedDecimalIntegerLiteral = new SignedDecimalIntegerLiteral(String.valueOf(obj), InputPosition$.MODULE$.NONE());
        } else if (object instanceof Double) {
            Double d = (Double)object;
            signedDecimalIntegerLiteral = new DecimalDoubleLiteral(String.valueOf(d), InputPosition$.MODULE$.NONE());
        } else if (object instanceof String) {
            String string = (String)object;
            signedDecimalIntegerLiteral = new StringLiteral(string, InputPosition$.MODULE$.NONE());
        } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)object)) {
            signedDecimalIntegerLiteral = new True(InputPosition$.MODULE$.NONE());
        } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)object)) {
            signedDecimalIntegerLiteral = new False(InputPosition$.MODULE$.NONE());
        } else if (object == null) {
            signedDecimalIntegerLiteral = new Null(InputPosition$.MODULE$.NONE());
        } else {
            throw new MatchError(object);
        }
        return signedDecimalIntegerLiteral;
    }

    public <T, P> GremlinSteps<T, P> runtimeValidation(GremlinSteps<T, P> throwIfTrue, CypherExceptions exception, WalkerContext<T, P> context) {
        return context.dsl().steps().start().sideEffect(throwIfTrue.constant(exception.toString()).map(CustomFunction.cypherException()));
    }

    public <T, P> boolean isElement(Expression expression, WalkerContext<T, P> context) {
        return context.expressionTypes().get((Object)expression).exists((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)NodeUtils$.$anonfun$isElement$1(x0$2)));
    }

    public <T, P> Seq<CypherType> qualifiedType(Expression expression, WalkerContext<T, P> context) {
        Seq seq;
        Option option = context.expressionTypes().get((Object)expression);
        if (option instanceof Some) {
            Some some = (Some)option;
            CypherType typ = (CypherType)some.value();
            seq = NodeUtils$.extractTyp$1(typ);
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyType[]{AnyType$.MODULE$.instance()}));
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$selectNestedAliases$1(WalkerContext context$6, String x$5) {
        return context$6.alias(x$5).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isElement$1(CypherType x0$2) {
        CypherType cypherType = x0$2;
        boolean bl = cypherType instanceof NodeType ? true : cypherType instanceof RelationshipType;
        boolean bl2 = bl;
        return bl2;
    }

    private static final Seq extractTyp$1(CypherType typ) {
        List list;
        CypherType cypherType = typ;
        if (cypherType instanceof ListType) {
            ListType listType;
            ListType listType2 = listType = (ListType)cypherType;
            list = (Seq)NodeUtils$.extractTyp$1(listType.innerType()).$plus$colon((Object)listType2, Seq$.MODULE$.canBuildFrom());
        } else {
            CypherType cypherType2 = typ;
            list = Nil$.MODULE$.$colon$colon((Object)cypherType2);
        }
        return list;
    }

    private NodeUtils$() {
        MODULE$ = this;
    }
}

