/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.translation.translator;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.opencypher.gremlin.translation.GremlinBindings;
import org.opencypher.gremlin.translation.GremlinPredicates;
import org.opencypher.gremlin.translation.GremlinSteps;
import org.opencypher.gremlin.translation.bytecode.BytecodeGremlinBindings;
import org.opencypher.gremlin.translation.bytecode.BytecodeGremlinPredicates;
import org.opencypher.gremlin.translation.bytecode.BytecodeGremlinSteps;
import org.opencypher.gremlin.translation.groovy.GroovyGremlinBindings;
import org.opencypher.gremlin.translation.groovy.GroovyGremlinPredicates;
import org.opencypher.gremlin.translation.groovy.GroovyGremlinSteps;
import org.opencypher.gremlin.translation.groovy.GroovyPredicate;
import org.opencypher.gremlin.translation.ir.rewrite.CustomFunctionFallback;
import org.opencypher.gremlin.translation.translator.TranslatorFeature;
import org.opencypher.gremlin.translation.translator.TranslatorFlavor;
import org.opencypher.gremlin.translation.traversal.TraversalGremlinBindings;
import org.opencypher.gremlin.translation.traversal.TraversalGremlinPredicates;
import org.opencypher.gremlin.translation.traversal.TraversalGremlinSteps;

public final class Translator<T, P> {
    private final GremlinSteps<T, P> steps;
    private final GremlinPredicates<P> predicates;
    private final GremlinBindings bindings;
    private final Set<TranslatorFeature> features;
    private final TranslatorFlavor flavor;

    private Translator(GremlinSteps<T, P> steps, GremlinPredicates<P> predicates, GremlinBindings bindings, Set<TranslatorFeature> features, TranslatorFlavor flavor) {
        this.steps = steps;
        this.predicates = predicates;
        this.bindings = bindings;
        this.features = features;
        this.flavor = flavor;
    }

    public GremlinSteps<T, P> steps() {
        return this.steps;
    }

    public GremlinPredicates<P> predicates() {
        return this.predicates;
    }

    public GremlinBindings bindings() {
        return this.bindings;
    }

    public boolean isEnabled(TranslatorFeature feature) {
        return this.features.contains((Object)feature);
    }

    public Set<TranslatorFeature> features() {
        return Collections.unmodifiableSet(this.features);
    }

    public TranslatorFlavor flavor() {
        return this.flavor;
    }

    public T translate() {
        return this.steps.current();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class ParametrizedFlavorBuilder<T, P>
    extends FlavorBuilder<T, P> {
        private ParametrizedFlavorBuilder(GremlinSteps<T, P> steps, GremlinPredicates<P> predicates, GremlinBindings bindings) {
            super(steps, predicates, bindings);
        }

        @Override
        public FlavorBuilder<T, P> inlineParameters() {
            return super.inlineParameters();
        }
    }

    public static class FlavorBuilder<T, P> {
        private static final Map<String, TranslatorFlavor> flavors = new HashMap<String, TranslatorFlavor>();
        private final GremlinSteps<T, P> steps;
        private final GremlinPredicates<P> predicates;
        protected GremlinBindings bindings;
        private final Set<TranslatorFeature> features = EnumSet.noneOf(TranslatorFeature.class);

        private FlavorBuilder(GremlinSteps<T, P> steps, GremlinPredicates<P> predicates, GremlinBindings bindings) {
            this.steps = steps;
            this.predicates = predicates;
            this.bindings = bindings;
        }

        public FlavorBuilder<T, P> enable(TranslatorFeature feature) {
            this.features.add(feature);
            return this;
        }

        public FlavorBuilder<T, P> enableCypherExtensions() {
            this.features.add(TranslatorFeature.CYPHER_EXTENSIONS);
            return this;
        }

        public FlavorBuilder<T, P> enableMultipleLabels() {
            this.features.add(TranslatorFeature.MULTIPLE_LABELS);
            return this;
        }

        public Translator<T, P> build() {
            return this.build((TranslatorFlavor)null);
        }

        public Translator<T, P> build(TranslatorFlavor flavor) {
            return new Translator(this.steps, this.predicates, this.bindings, this.features, this.getFlavor(flavor, this.features));
        }

        public Translator<T, P> build(String translatorDefinition) {
            String[] tokens = translatorDefinition.split("\\+");
            String flavorName = tokens[0].toLowerCase();
            if (!flavorName.equals("") && !flavors.containsKey(flavorName)) {
                throw new IllegalArgumentException(this.errorMessage("Unknown translator type: " + flavorName, translatorDefinition));
            }
            TranslatorFlavor flavor = flavors.getOrDefault(flavorName, TranslatorFlavor.gremlinServer());
            if (flavorName.equals("neptune")) {
                this.inlineParameters();
                this.enableMultipleLabels();
            }
            List<String> features = Arrays.asList(tokens).subList(1, tokens.length);
            for (String feature : features) {
                if ("".equals(feature = feature.trim())) continue;
                if ("inline_parameters".equals(feature)) {
                    this.inlineParameters();
                    continue;
                }
                if ("cfog_server_extensions".equals(feature)) {
                    this.enableCypherExtensions();
                    continue;
                }
                try {
                    TranslatorFeature translatorFeature = TranslatorFeature.valueOf(feature.toUpperCase());
                    this.features.add(translatorFeature);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(this.errorMessage("Unknown translator feature: " + feature, translatorDefinition), e);
                }
            }
            return this.build(flavor);
        }

        private String errorMessage(String start, String translatorDefinition) {
            String validMethods = String.join((CharSequence)", ", flavors.keySet());
            String validFeatures = Arrays.stream(TranslatorFeature.values()).map(f -> f.name().toLowerCase()).collect(Collectors.joining(", ")) + ", inline_parameters, cfog_server_extensions";
            return String.format("%s in `%s`\nFormat is `FLAVOR[+FEATURE][+FEATURE]...`\nValid FLAVOR: %s\nValid FEATURE: %s\nExample: gremlin+cfog_server_extensions+inline_parameters", start, translatorDefinition, validMethods, validFeatures);
        }

        protected FlavorBuilder<T, P> inlineParameters() {
            this.bindings = new TraversalGremlinBindings();
            return this;
        }

        private TranslatorFlavor getFlavor(TranslatorFlavor flavor, Set<TranslatorFeature> features) {
            TranslatorFlavor result;
            TranslatorFlavor translatorFlavor = result = flavor != null ? flavor : TranslatorFlavor.gremlinServer();
            if (features.contains((Object)TranslatorFeature.CYPHER_EXTENSIONS)) {
                return result;
            }
            return TranslatorFlavor.empty().extend(CustomFunctionFallback.prepend(result.rewriters()), result.postConditions());
        }

        static {
            flavors.put("gremlinserver34x", TranslatorFlavor.gremlinServer34x());
            flavors.put("gremlinserver", TranslatorFlavor.gremlinServer());
            flavors.put("gremlin", TranslatorFlavor.gremlin());
            flavors.put("gremlinserver33x", TranslatorFlavor.gremlinServer33x());
            flavors.put("gremlin33x", TranslatorFlavor.gremlin33x());
            flavors.put("cosmosdb", TranslatorFlavor.cosmosDb());
            flavors.put("neptune", TranslatorFlavor.neptune());
            flavors.put("empty", TranslatorFlavor.empty());
        }
    }

    public static final class Builder {
        private Builder() {
        }

        public ParametrizedFlavorBuilder<String, GroovyPredicate> gremlinGroovy() {
            return new ParametrizedFlavorBuilder<String, GroovyPredicate>(new GroovyGremlinSteps(), new GroovyGremlinPredicates(), new GroovyGremlinBindings());
        }

        public ParametrizedFlavorBuilder<Bytecode, P> bytecode() {
            return new ParametrizedFlavorBuilder<Bytecode, P>(new BytecodeGremlinSteps(), new BytecodeGremlinPredicates(), new BytecodeGremlinBindings());
        }

        public FlavorBuilder<GraphTraversal, P> traversal() {
            return this.traversal((GraphTraversal)new DefaultGraphTraversal());
        }

        public FlavorBuilder<GraphTraversal, P> traversal(GraphTraversal g) {
            return new FlavorBuilder<GraphTraversal, P>(new TraversalGremlinSteps(g), new TraversalGremlinPredicates(), new TraversalGremlinBindings());
        }

        public <T, P> FlavorBuilder<T, P> custom(GremlinSteps<T, P> steps, GremlinPredicates<P> predicates, GremlinBindings parameters) {
            return new FlavorBuilder(steps, predicates, parameters);
        }
    }
}

