/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.CharToByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.CharToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.CharToIntFunction;
import org.eclipse.collections.api.block.function.primitive.CharToLongFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.factory.primitive.CharBags;
import org.eclipse.collections.api.factory.primitive.CharLists;
import org.eclipse.collections.api.factory.primitive.CharSets;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.impl.lazy.primitive.ChunkCharIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToBooleanIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToByteIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToCharIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToDoubleIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToFloatIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToIntIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToLongIterable;
import org.eclipse.collections.impl.lazy.primitive.CollectCharToShortIterable;
import org.eclipse.collections.impl.utility.internal.primitive.CharIterableIterate;
import org.eclipse.collections.impl.utility.primitive.LazyCharIterate;

public abstract class AbstractLazyCharIterable
implements LazyCharIterable {
    public int size() {
        return this.count((CharPredicate & Serializable)value -> true);
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public boolean isEmpty() {
        return CharIterableIterate.isEmpty((CharIterable)this);
    }

    public boolean notEmpty() {
        return CharIterableIterate.notEmpty((CharIterable)this);
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        CharIterableIterate.appendString((CharIterable)this, appendable, start, separator, end);
    }

    public boolean contains(char value) {
        return this.anySatisfy((CharPredicate & Serializable)each -> each == value);
    }

    public boolean containsAll(char ... source) {
        return this.containsAll((CharIterable)CharSets.immutable.of(source));
    }

    public boolean containsAll(CharIterable source) {
        return source.allSatisfy((CharPredicate & Serializable)value -> this.contains(value));
    }

    public LazyCharIterable select(CharPredicate predicate) {
        return LazyCharIterate.select((CharIterable)this, predicate);
    }

    public LazyCharIterable reject(CharPredicate predicate) {
        return LazyCharIterate.select((CharIterable)this, (CharPredicate & Serializable)value -> !predicate.accept(value));
    }

    public LazyCharIterable tap(CharProcedure procedure) {
        return LazyCharIterate.tap((CharIterable)this, procedure);
    }

    public <V> LazyIterable<V> collect(CharToObjectFunction<? extends V> function) {
        return LazyCharIterate.collect((CharIterable)this, function);
    }

    public <V> LazyIterable<V> flatCollect(CharToObjectFunction<? extends Iterable<V>> function) {
        return LazyCharIterate.flatCollect((CharIterable)this, function);
    }

    public LazyBooleanIterable collectBoolean(CharToBooleanFunction function) {
        return new CollectCharToBooleanIterable((CharIterable)this, function);
    }

    public LazyByteIterable collectByte(CharToByteFunction function) {
        return new CollectCharToByteIterable((CharIterable)this, function);
    }

    public LazyCharIterable collectChar(CharToCharFunction function) {
        return new CollectCharToCharIterable((CharIterable)this, function);
    }

    public LazyShortIterable collectShort(CharToShortFunction function) {
        return new CollectCharToShortIterable((CharIterable)this, function);
    }

    public LazyIntIterable collectInt(CharToIntFunction function) {
        return new CollectCharToIntIterable((CharIterable)this, function);
    }

    public LazyFloatIterable collectFloat(CharToFloatFunction function) {
        return new CollectCharToFloatIterable((CharIterable)this, function);
    }

    public LazyLongIterable collectLong(CharToLongFunction function) {
        return new CollectCharToLongIterable((CharIterable)this, function);
    }

    public LazyDoubleIterable collectDouble(CharToDoubleFunction function) {
        return new CollectCharToDoubleIterable((CharIterable)this, function);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return CharIterableIterate.detectIfNone((CharIterable)this, predicate, ifNone);
    }

    public int count(CharPredicate predicate) {
        return CharIterableIterate.count((CharIterable)this, predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return CharIterableIterate.anySatisfy((CharIterable)this, predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return CharIterableIterate.allSatisfy((CharIterable)this, predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return CharIterableIterate.noneSatisfy((CharIterable)this, predicate);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return CharIterableIterate.injectInto((CharIterable)this, injectedValue, function);
    }

    public RichIterable<CharIterable> chunk(int size) {
        return new ChunkCharIterable((CharIterable)this, size);
    }

    public char[] toArray() {
        return this.toList().toArray();
    }

    public MutableCharList toList() {
        MutableCharList list = CharLists.mutable.empty();
        this.forEach(arg_0 -> ((MutableCharList)list).add(arg_0));
        return list;
    }

    public MutableCharSet toSet() {
        MutableCharSet set = CharSets.mutable.empty();
        this.forEach(arg_0 -> ((MutableCharSet)set).add(arg_0));
        return set;
    }

    public MutableCharBag toBag() {
        MutableCharBag bag = CharBags.mutable.empty();
        this.forEach(arg_0 -> ((MutableCharBag)bag).add(arg_0));
        return bag;
    }

    public long sum() {
        CharSumProcedure procedure = new CharSumProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public char max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharMaxProcedure procedure = new CharMaxProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public char maxIfEmpty(char ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.max();
    }

    public char min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        CharMinProcedure procedure = new CharMinProcedure();
        this.forEach(procedure);
        return procedure.getValue();
    }

    public char minIfEmpty(char ifEmpty) {
        if (this.isEmpty()) {
            return ifEmpty;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        char[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            char first = sortedArray[middleIndex];
            char second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public char[] toSortedArray() {
        return this.toSortedList().toArray();
    }

    public MutableCharList toSortedList() {
        return CharLists.mutable.withAll((CharIterable)this).sortThis();
    }

    public LazyCharIterable asLazy() {
        return this;
    }

    private static final class CharSumProcedure
    implements CharProcedure {
        private char sum = '\u0000';

        private CharSumProcedure() {
        }

        public void value(char each) {
            this.sum = (char)(this.sum + each);
        }

        public char getValue() {
            return this.sum;
        }
    }

    private static final class CharMinProcedure
    implements CharProcedure {
        private boolean visitedOnce;
        private char min;

        private CharMinProcedure() {
        }

        public void value(char each) {
            if (this.visitedOnce) {
                if (each < this.min) {
                    this.min = each;
                }
            } else {
                this.min = each;
                this.visitedOnce = true;
            }
        }

        public char getValue() {
            return this.min;
        }
    }

    private static final class CharMaxProcedure
    implements CharProcedure {
        private boolean visitedOnce;
        private char max;

        private CharMaxProcedure() {
        }

        public void value(char each) {
            if (this.visitedOnce) {
                if (this.max < each) {
                    this.max = each;
                }
            } else {
                this.max = each;
                this.visitedOnce = true;
            }
        }

        public char getValue() {
            return this.max;
        }
    }
}

