/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.Arrays;
import java.util.function.Supplier;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.internal.util.DelegatingScheduler;

public class Execution
extends AbstractExecution {
    public Execution(Policy ... policies) {
        super(DelegatingScheduler.INSTANCE, new FailsafeExecutor<Object>(Arrays.asList((Object[])Assert.notNull(policies, "policies"))));
        this.preExecute();
    }

    Execution(FailsafeExecutor<?> executor) {
        super(DelegatingScheduler.INSTANCE, executor);
    }

    public boolean canRetryFor(Object result) {
        this.preExecute();
        this.postExecute(new ExecutionResult(result, null));
        return !this.completed;
    }

    public boolean canRetryFor(Object result, Throwable failure) {
        this.preExecute();
        this.postExecute(new ExecutionResult(result, failure));
        return !this.completed;
    }

    public boolean canRetryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        this.preExecute();
        this.postExecute(new ExecutionResult(null, failure));
        return !this.completed;
    }

    public void complete() {
        this.postExecute(ExecutionResult.NONE);
    }

    public boolean complete(Object result) {
        this.preExecute();
        this.postExecute(new ExecutionResult(result, null));
        return this.completed;
    }

    public boolean recordFailure(Throwable failure) {
        return this.canRetryOn(failure);
    }

    ExecutionResult executeSync(Supplier<ExecutionResult> supplier) {
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            supplier = policyExecutor.supply(supplier, this.scheduler);
        }
        ExecutionResult result = supplier.get();
        this.completed = result.isComplete();
        this.executor.handleComplete(result, this);
        return result;
    }
}

