/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.Request;

class BaseOperationRequestBuilder<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private final URL requestUrl;
    private final BaseOperation<T, L, ?> baseOperation;
    private final ListOptions listOptions;

    public BaseOperationRequestBuilder(BaseOperation<T, L, ?> baseOperation, ListOptions listOptions) throws MalformedURLException {
        this.baseOperation = baseOperation;
        this.requestUrl = baseOperation.getNamespacedUrl();
        this.listOptions = listOptions;
    }

    public BaseOperation<T, L, ?> getBaseOperation() {
        return this.baseOperation;
    }

    public Request build(String resourceVersion) {
        Map<String, String> customHeaders;
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get((URL)this.requestUrl).newBuilder();
        String labelQueryParam = this.baseOperation.getLabelQueryParam();
        if (Utils.isNotNullOrEmpty(labelQueryParam)) {
            httpUrlBuilder.addQueryParameter("labelSelector", labelQueryParam);
        }
        String fieldQueryString = this.baseOperation.getFieldQueryParam();
        String name = this.baseOperation.getName();
        if (name != null && name.length() > 0) {
            if (fieldQueryString.length() > 0) {
                fieldQueryString = fieldQueryString + ",";
            }
            fieldQueryString = fieldQueryString + "metadata.name=" + name;
        }
        if (Utils.isNotNullOrEmpty(fieldQueryString)) {
            httpUrlBuilder.addQueryParameter("fieldSelector", fieldQueryString);
        }
        this.listOptions.setResourceVersion(resourceVersion);
        HttpClientUtils.appendListOptionParams(httpUrlBuilder, this.listOptions);
        String origin = this.requestUrl.getProtocol() + "://" + this.requestUrl.getHost();
        if (this.requestUrl.getPort() != -1) {
            origin = origin + ":" + this.requestUrl.getPort();
        }
        Request.Builder requestBuilder = new Request.Builder().get().url(httpUrlBuilder.build()).addHeader("Origin", origin);
        Config config = this.baseOperation.getConfig();
        if (Objects.nonNull(config) && Objects.nonNull(customHeaders = config.getCustomHeaders()) && !customHeaders.isEmpty()) {
            for (String key : customHeaders.keySet()) {
                requestBuilder.addHeader(key, customHeaders.get(key));
            }
        }
        return requestBuilder.build();
    }
}

