/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api;

import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Tag;
import com.alipay.lookout.api.TagSet;
import com.alipay.lookout.common.Assert;
import java.util.Arrays;
import java.util.Map;

final class DefaultId
implements Id {
    private final String name;
    private final TagSet tags;

    public DefaultId(String name) {
        this(name, TagSet.EMPTY);
    }

    DefaultId(String name, TagSet tags) {
        this.name = Assert.notNull(name, "name");
        this.tags = Assert.notNull(tags, "tags");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<Tag> tags() {
        return this.tags;
    }

    @Override
    public DefaultId withTag(Tag tag) {
        return new DefaultId(this.name, this.tags.add(tag));
    }

    @Override
    public DefaultId withTag(String key, String value) {
        return new DefaultId(this.name, this.tags.add(key, value));
    }

    @Override
    public DefaultId withTags(Tag ... ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Iterable<Tag> ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    @Override
    public DefaultId withTags(Map<String, String> ts) {
        return new DefaultId(this.name, this.tags.addAll(ts));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DefaultId)) {
            return false;
        }
        DefaultId other = (DefaultId)obj;
        return this.name.equals(other.name) && this.tags.equals(other.tags);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.tags});
    }

    public String toString() {
        return this.name + this.tags;
    }
}

