/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.ReflectionUtil;

public final class CopyUtil {
    public static <T> T cloneObject(T o, T clone) throws Exception {
        if (clone == null) {
            clone = o.getClass().newInstance();
        }
        for (Field field : o.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object value = field.get(o);
            if (value == null || Modifier.isFinal(field.getModifiers())) continue;
            Class<?> declareType = field.getType();
            Class<?> valueType = value.getClass();
            if (ReflectionUtil.isSimpleType(declareType) || ReflectionUtil.isSimpleType(valueType)) {
                field.set(clone, value);
                continue;
            }
            if (declareType.isArray() && valueType.isArray() && valueType.getComponentType().isPrimitive()) {
                field.set(clone, CopyUtil.cloneArray(value));
                continue;
            }
            if (value == o) {
                field.set(clone, clone);
                continue;
            }
            field.set(clone, CopyUtil.cloneObject(value, null));
        }
        return clone;
    }

    private static Object cloneArray(Object value) {
        Class<?> valueType = value.getClass();
        assert (valueType.isArray() && valueType.getComponentType().isPrimitive());
        int len = Array.getLength(value);
        Object array = Array.newInstance(valueType.getComponentType(), len);
        System.arraycopy(value, 0, array, 0, len);
        return array;
    }

    public static <T> T copy(T object) {
        return CopyUtil.copy(object, null);
    }

    public static <T> T copy(T object, T clone) {
        try {
            return CopyUtil.cloneObject(object, clone);
        }
        catch (Exception e) {
            throw new HugeException("Failed to clone object", e);
        }
    }

    public static <T> T deepCopy(T object) {
        Class<?> cls = object.getClass();
        return (T)JsonUtil.fromJson(JsonUtil.toJson(object), cls);
    }
}

