/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class SameNeighborTraverser
extends HugeTraverser {
    public SameNeighborTraverser(HugeGraph graph) {
        super(graph);
    }

    public Set<Id> sameNeighbors(Id vertex, Id other, Directions direction, String label, long degree, int limit) {
        E.checkNotNull((Object)vertex, (String)"vertex id");
        E.checkNotNull((Object)other, (String)"the other vertex id");
        this.checkVertexExist(vertex, "vertex");
        this.checkVertexExist(other, "other vertex");
        E.checkNotNull((Object)direction, (String)"direction");
        SameNeighborTraverser.checkDegree(degree);
        SameNeighborTraverser.checkLimit(limit);
        Id labelId = this.getEdgeLabelIdOrNull(label);
        Set sourceNeighbors = IteratorUtils.set(this.adjacentVertices(vertex, direction, labelId, degree));
        Set targetNeighbors = IteratorUtils.set(this.adjacentVertices(other, direction, labelId, degree));
        Set sameNeighbors = (Set)CollectionUtil.intersect((Collection)sourceNeighbors, (Collection)targetNeighbors);
        this.vertexIterCounter.addAndGet(2L);
        this.edgeIterCounter.addAndGet(sourceNeighbors.size());
        this.edgeIterCounter.addAndGet(targetNeighbors.size());
        if ((long)limit != -1L) {
            int end = Math.min(sameNeighbors.size(), limit);
            sameNeighbors = CollectionUtil.subSet((Set)sameNeighbors, (int)0, (int)end);
        }
        return sameNeighbors;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Id> sameNeighbors(List<Id> vertexIds, Directions direction, List<String> labels, long degree, int limit) {
        void var8_16;
        void var8_11;
        E.checkNotNull(vertexIds, (String)"vertex ids");
        E.checkArgument((vertexIds.size() >= 2 ? 1 : 0) != 0, (String)"vertex_list size can't be less than 2", (Object[])new Object[0]);
        for (Id id : vertexIds) {
            this.checkVertexExist(id, "vertex");
        }
        E.checkNotNull((Object)direction, (String)"direction");
        SameNeighborTraverser.checkDegree(degree);
        SameNeighborTraverser.checkLimit(limit);
        ArrayList<Id> labelsId = new ArrayList<Id>();
        if (labels != null) {
            for (String label : labels) {
                labelsId.add(this.getEdgeLabelIdOrNull(label));
            }
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < vertexIds.size(); ++i) {
            Set vertexNeighbors = IteratorUtils.set(this.adjacentVertices(vertexIds.get(i), direction, labelsId, degree));
            if (i == 0) {
                Set set = vertexNeighbors;
            } else {
                Set set = (Set)CollectionUtil.intersect((Collection)var8_11, (Collection)vertexNeighbors);
            }
            this.vertexIterCounter.addAndGet(1L);
            this.edgeIterCounter.addAndGet(vertexNeighbors.size());
        }
        if ((long)limit != -1L) {
            int end = Math.min(var8_11.size(), limit);
            Set set = CollectionUtil.subSet((Set)var8_11, (int)0, (int)end);
        }
        return var8_16;
    }
}

