/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.iterator.FilterIterator;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class EdgeExistenceTraverser
extends HugeTraverser {
    public EdgeExistenceTraverser(HugeGraph graph) {
        super(graph);
    }

    public Iterator<Edge> queryEdgeExistence(Id sourceId, Id targetId, String label, String sortValues, long limit) {
        if (label == null || label.isEmpty()) {
            return this.queryByNeighbors(sourceId, targetId, limit);
        }
        EdgeLabel edgeLabel = this.graph().edgeLabel(label);
        ConditionQuery conditionQuery = new ConditionQuery(HugeType.EDGE);
        conditionQuery.eq(HugeKeys.OWNER_VERTEX, sourceId);
        conditionQuery.eq(HugeKeys.OTHER_VERTEX, targetId);
        conditionQuery.eq(HugeKeys.LABEL, edgeLabel.id());
        conditionQuery.eq(HugeKeys.DIRECTION, Directions.OUT);
        conditionQuery.limit(limit);
        if (edgeLabel.existSortKeys() && !sortValues.isEmpty()) {
            conditionQuery.eq(HugeKeys.SORT_VALUES, sortValues);
        } else {
            conditionQuery.eq(HugeKeys.SORT_VALUES, "");
        }
        return this.graph().edges(conditionQuery);
    }

    private Iterator<Edge> queryByNeighbors(Id sourceId, Id targetId, long limit) {
        return new FilterIterator(this.edgesOfVertex(sourceId, Directions.OUT, (Id)null, limit), edge -> targetId.equals(edge.inVertex().id()));
    }
}

