/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.space.register.registerImpl;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.hugegraph.pd.client.DiscoveryClient;
import org.apache.hugegraph.pd.client.DiscoveryClientImpl;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfos;
import org.apache.hugegraph.space.register.IServiceRegister;
import org.apache.hugegraph.space.register.RegisterConfig;
import org.apache.hugegraph.space.register.dto.ServiceDTO;

public class SampleRegister
implements IServiceRegister {
    private DiscoveryClient client = null;

    private RegisterConfig decodeConfigMap(String configMap) {
        RegisterConfig config = new RegisterConfig();
        Gson gson = new Gson();
        ServiceDTO serviceDTO = (ServiceDTO)gson.fromJson(configMap, ServiceDTO.class);
        config.setNodePort(serviceDTO.getSpec().getPorts().get(0).getNodePort().toString());
        config.setNodeName(serviceDTO.getSpec().getClusterIP());
        config.setPodIp("127.0.0.1");
        config.setPodPort("8080");
        return config;
    }

    @Override
    public String init(String appName) throws Exception {
        String string;
        File file = new File("/home/scorpiour/HugeGraph/hugegraph-plugin/example/k8s-service.json");
        FileInputStream input = new FileInputStream(file);
        try {
            System.out.printf("load file: %s%n", file.toPath());
            long fileLength = file.length();
            byte[] bytes = new byte[(int)fileLength];
            input.read(bytes);
            String configMap = new String(bytes);
            RegisterConfig config = this.decodeConfigMap(configMap);
            config.setGrpcAddress("127.0.0.1:8686");
            config.setAppName(appName);
            System.out.printf("load file: %s%n", file.toPath());
            string = this.registerService(config);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return "";
            }
        }
        input.close();
        return string;
    }

    @Override
    public String registerService(RegisterConfig config) {
        if (null != this.client) {
            this.client.cancelTask();
        }
        System.out.println("going to attach client");
        String address = config.getNodeName() + ":" + config.getNodePort();
        String clientId = config.getAppName() + ":" + address;
        try {
            PDConfig pdConfig = PDConfig.of((String)config.getGrpcAddress());
            pdConfig.setAuthority("hg", "");
            DiscoveryClientImpl client = DiscoveryClientImpl.newBuilder().setPdConfig(pdConfig).setCenterAddress(config.getGrpcAddress()).setAddress(address).setAppName(config.getAppName()).setDelay(config.getInterval()).setVersion(config.getVersion()).setId(clientId).setLabels(config.getLabelMap()).build();
            this.client = client;
            client.scheduleTask();
            System.out.println("going to schedule client");
            return clientId;
        }
        catch (Exception var6) {
            return "";
        }
    }

    @Override
    public void unregister(RegisterConfig config) {
        this.unregisterAll();
    }

    @Override
    public void unregister(String id) {
        this.unregisterAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAll() {
        if (null != this.client) {
            DiscoveryClient discoveryClient = this.client;
            synchronized (discoveryClient) {
                this.client.cancelTask();
            }
        }
    }

    @Override
    public Map<String, NodeInfos> getServiceInfo(String serviceId) {
        return null;
    }

    @Override
    public void close() {
    }
}

