/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;
import org.apache.hugegraph.space.SchemaTemplate;
import org.apache.hugegraph.util.JsonUtil;

public class SchemaTemplateMetaManager
extends AbstractMetaManager {
    public SchemaTemplateMetaManager(MetaDriver metaDriver, String cluster) {
        super(metaDriver, cluster);
    }

    public Set<String> schemaTemplates(String graphSpace) {
        HashSet<String> result = new HashSet<String>();
        Map<String, String> keyValues = this.metaDriver.scanWithPrefix(this.schemaTemplatePrefix(graphSpace));
        for (String key : keyValues.keySet()) {
            String[] parts = key.split("/");
            result.add(parts[parts.length - 1]);
        }
        return result;
    }

    public SchemaTemplate schemaTemplate(String graphSpace, String schemaTemplate) {
        String s = this.metaDriver.get(this.schemaTemplateKey(graphSpace, schemaTemplate));
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return SchemaTemplate.fromMap(JsonUtil.fromJson(s, Map.class));
    }

    public void addSchemaTemplate(String graphSpace, SchemaTemplate template) {
        String key = this.schemaTemplateKey(graphSpace, template.name());
        String data = this.metaDriver.get(key);
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            throw new HugeException("Cannot create schema template since it has been created");
        }
        this.metaDriver.put(this.schemaTemplateKey(graphSpace, template.name()), JsonUtil.toJson(template.asMap()));
    }

    public void updateSchemaTemplate(String graphSpace, SchemaTemplate template) {
        this.metaDriver.put(this.schemaTemplateKey(graphSpace, template.name()), JsonUtil.toJson(template.asMap()));
    }

    public void removeSchemaTemplate(String graphSpace, String name) {
        this.metaDriver.delete(this.schemaTemplateKey(graphSpace, name));
    }

    public void clearSchemaTemplate(String graphSpace) {
        String prefix = this.schemaTemplatePrefix(graphSpace);
        this.metaDriver.deleteWithPrefix(prefix);
    }

    private String schemaTemplatePrefix(String graphSpace) {
        return this.schemaTemplateKey(graphSpace, "");
    }

    private String schemaTemplateKey(String graphSpace, String schemaTemplate) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "SCHEMA_TEMPLATE", schemaTemplate);
    }
}

