/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.impl.property;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.util.FurySerializationUtil;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeEdgeProperty;
import org.apache.hugegraph.structure.HugeElement;

public class HugeEdgePropertyOffHeap<V>
extends HugeEdgeProperty<V>
implements OffHeapObject {
    private ByteBuf valueOffHeap;

    public HugeEdgePropertyOffHeap(MemoryPool memoryPool, HugeElement owner, PropertyKey key, V value) {
        super(owner, key, value);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    @Override
    public Object zeroCopyReadFromByteBuf() {
        return new HugeEdgeProperty<Object>(this.owner, this.pkey, FurySerializationUtil.FURY.deserialize(ByteBufUtil.getBytes((ByteBuf)this.valueOffHeap)));
    }

    @Override
    public void serializeSelfToByteBuf(MemoryPool memoryPool) {
        byte[] bytes = FurySerializationUtil.FURY.serialize(this.value);
        this.valueOffHeap = (ByteBuf)memoryPool.requireMemory(bytes.length, memoryPool);
        this.valueOffHeap.markReaderIndex();
        this.valueOffHeap.writeBytes(bytes);
    }

    @Override
    public void releaseOriginalVarsOnHeap() {
        this.value = null;
    }

    @Override
    public List<ByteBuf> getAllMemoryBlock() {
        return Collections.singletonList(this.valueOffHeap);
    }

    @Override
    public HugeEdgeProperty<V> switchEdgeOwner() {
        assert (this.owner instanceof HugeEdge);
        return new HugeEdgeProperty<V>(((HugeEdge)this.owner).switchOwner(), this.pkey, this.value());
    }

    @Override
    public Object serialValue(boolean encodeNumber) {
        return this.pkey.serialValue(this.value(), encodeNumber);
    }

    @Override
    public boolean isPresent() {
        return this.value() != null;
    }

    @Override
    public V value() throws NoSuchElementException {
        return (V)FurySerializationUtil.FURY.deserialize(ByteBufUtil.getBytes((ByteBuf)this.valueOffHeap));
    }
}

