/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.impl.id;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.util.FurySerializationUtil;
import org.apache.hugegraph.memory.util.SerializationRuntimeException;
import org.apache.hugegraph.util.E;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UuidIdOffHeap
extends IdGenerator.UuidId
implements OffHeapObject {
    private static final Logger LOG = LoggerFactory.getLogger(UuidIdOffHeap.class);
    private ByteBuf idOffHeap;

    public UuidIdOffHeap(MemoryPool memoryPool, String string) {
        super(string);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    public UuidIdOffHeap(MemoryPool memoryPool, byte[] bytes) {
        super(bytes);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    public UuidIdOffHeap(MemoryPool memoryPool, UUID uuid) {
        super(uuid);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    @Override
    public Object zeroCopyReadFromByteBuf() {
        return new IdGenerator.UuidId((UUID)FurySerializationUtil.FURY.deserialize(ByteBufUtil.getBytes((ByteBuf)this.idOffHeap)));
    }

    @Override
    public void serializeSelfToByteBuf(MemoryPool memoryPool) {
        byte[] bytes = FurySerializationUtil.FURY.serialize((Object)this.uuid);
        this.idOffHeap = (ByteBuf)memoryPool.requireMemory(bytes.length, memoryPool);
        this.idOffHeap.markReaderIndex();
        this.idOffHeap.writeBytes(bytes);
    }

    @Override
    public void releaseOriginalVarsOnHeap() {
        this.uuid = null;
    }

    @Override
    public List<ByteBuf> getAllMemoryBlock() {
        return Collections.singletonList(this.idOffHeap);
    }

    @Override
    public Object asObject() {
        return FurySerializationUtil.FURY.deserialize(ByteBufUtil.getBytes((ByteBuf)this.idOffHeap));
    }

    @Override
    public String asString() {
        return this.asObject().toString();
    }

    @Override
    public byte[] asBytes() {
        byte[] byArray;
        block8: {
            BytesBuffer buffer = BytesBuffer.allocate(16);
            try {
                UUID tmp = (UUID)this.asObject();
                buffer.writeLong(tmp.getMostSignificantBits());
                buffer.writeLong(tmp.getLeastSignificantBits());
                byArray = buffer.bytes();
                if (buffer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (buffer != null) {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Unexpected error occurs when allocate bytesBuffer.", (Throwable)e);
                    throw new SerializationRuntimeException(e);
                }
            }
            buffer.close();
        }
        return byArray;
    }

    @Override
    public int compareTo(Id other) {
        E.checkNotNull((Object)other, (String)"compare id");
        int cmp = IdGenerator.compareType(this, other);
        if (cmp != 0) {
            return cmp;
        }
        return ((UUID)this.asObject()).compareTo((UUID)other.asObject());
    }

    @Override
    public int hashCode() {
        return this.idOffHeap.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof UuidIdOffHeap)) {
            return false;
        }
        return this.asObject().equals(((UuidIdOffHeap)other).asObject());
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

