/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.allocator;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.allocator.MemoryAllocator;

public class NettyMemoryAllocator
implements MemoryAllocator {
    private final PooledByteBufAllocator offHeapAllocator = PooledByteBufAllocator.DEFAULT;
    private final MemoryManager memoryManager;

    public NettyMemoryAllocator(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public ByteBuf forceAllocate(long size) {
        this.memoryManager.getCurrentOffHeapAllocatedMemoryInBytes().addAndGet(size);
        return this.offHeapAllocator.directBuffer((int)size);
    }

    public ByteBuf tryToAllocate(long size) {
        if (this.memoryManager.getCurrentOnHeapAllocatedMemoryInBytes().get() + this.memoryManager.getCurrentOffHeapAllocatedMemoryInBytes().get() + size < MemoryManager.MAX_MEMORY_CAPACITY_IN_BYTES) {
            this.memoryManager.getCurrentOffHeapAllocatedMemoryInBytes().addAndGet(size);
            return this.offHeapAllocator.directBuffer((int)size);
        }
        return null;
    }

    @Override
    public void returnMemoryToManager(long size) {
        this.memoryManager.getCurrentOffHeapAllocatedMemoryInBytes().addAndGet(-size);
    }

    @Override
    public void releaseMemoryBlock(Object memoryBlock) {
        if (!(memoryBlock instanceof ByteBuf)) {
            throw new IllegalArgumentException(String.format("memoryBlock must be ByteBuf, current class: %s", memoryBlock.getClass()));
        }
        ByteBuf buf = (ByteBuf)memoryBlock;
        ReferenceCountUtil.safeRelease((Object)buf);
    }
}

