/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory;

import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.memory.arbitrator.MemoryArbitrator;
import org.apache.hugegraph.memory.arbitrator.MemoryArbitratorImpl;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.pool.impl.QueryMemoryPool;
import org.apache.hugegraph.memory.pool.impl.TaskMemoryPool;
import org.apache.hugegraph.util.ExecutorUtil;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryManager.class);
    private static final int ARBITRATE_MEMORY_THREAD_NUM = 12;
    private static final String QUERY_MEMORY_POOL_NAME_PREFIX = "QueryMemoryPool";
    private static final String ARBITRATE_MEMORY_POOL_NAME = "ArbitrateMemoryPool";
    public static final String DELIMINATOR = "_";
    public static long MAX_MEMORY_CAPACITY_IN_BYTES = 0x40000000L;
    public static long MAX_MEMORY_CAPACITY_FOR_ONE_QUERY = 0x6400000L;
    private final AtomicLong currentAvailableMemoryInBytes = new AtomicLong(MAX_MEMORY_CAPACITY_IN_BYTES);
    private final AtomicLong currentOffHeapAllocatedMemoryInBytes = new AtomicLong(0L);
    private final AtomicLong currentOnHeapAllocatedMemoryInBytes = new AtomicLong(0L);
    private final Queue<MemoryPool> queryMemoryPools = new PriorityQueue<MemoryPool>((o1, o2) -> (int)(o2.getFreeBytes() - o1.getFreeBytes()));
    private final Map<String, TaskMemoryPool> threadName2TaskMemoryPoolMap = new ConcurrentHashMap<String, TaskMemoryPool>();
    private final MemoryArbitrator memoryArbitrator = new MemoryArbitratorImpl(this);
    private final ExecutorService arbitrateExecutor = ExecutorUtil.newFixedThreadPool((int)12, (String)"ArbitrateMemoryPool");
    private static MemoryMode MEMORY_MODE = MemoryMode.ENABLE_OFF_HEAP_MANAGEMENT;

    private MemoryManager() {
    }

    public MemoryPool addQueryMemoryPool() {
        int count = this.queryMemoryPools.size();
        String poolName = "QueryMemoryPool_" + count + DELIMINATOR + System.currentTimeMillis();
        QueryMemoryPool queryPool = new QueryMemoryPool(poolName, this);
        this.queryMemoryPools.add(queryPool);
        LOG.info("Manager added query memory pool {}", (Object)queryPool);
        return queryPool;
    }

    public void gcQueryMemoryPool(MemoryPool pool) {
        LOG.info("Manager gc query memory pool {}", (Object)pool);
        this.queryMemoryPools.remove(pool);
        pool.releaseSelf(String.format("GC query memory pool %s", pool), false);
    }

    public void returnReclaimedTaskMemory(long bytes) {
        this.currentAvailableMemoryInBytes.addAndGet(bytes);
    }

    public void consumeAvailableMemory(long size) {
        this.currentAvailableMemoryInBytes.addAndGet(-size);
    }

    public long triggerLocalArbitration(MemoryPool targetPool, long neededBytes, MemoryPool requestPool) {
        LOG.info("LocalArbitration triggered by {}: needed bytes={}", (Object)targetPool, (Object)neededBytes);
        Future<Long> future = this.arbitrateExecutor.submit(() -> this.memoryArbitrator.reclaimLocally(targetPool, neededBytes, requestPool));
        try {
            return future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("MemoryManager: arbitration locally for {} timed out", (Object)targetPool, (Object)e);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("MemoryManager: arbitration locally for {} interrupted or failed", (Object)targetPool, (Object)e);
        }
        return 0L;
    }

    public long triggerGlobalArbitration(MemoryPool requestPool, long neededBytes) {
        LOG.info("GlobalArbitration triggered by {}: needed bytes={}", (Object)requestPool, (Object)neededBytes);
        Future<Long> future = this.arbitrateExecutor.submit(() -> this.memoryArbitrator.reclaimGlobally(requestPool, neededBytes));
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("MemoryManager: arbitration globally for {} timed out", (Object)requestPool, (Object)e);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("MemoryManager: arbitration globally for {} interrupted or failed", (Object)requestPool, (Object)e);
        }
        return 0L;
    }

    public synchronized long handleRequestFromQueryPool(long size, String action) {
        if (this.currentAvailableMemoryInBytes.get() < size) {
            LOG.info("There isn't enough memory for query pool to {}: requestSize={}, remainingCapacity={}", new Object[]{size, action, this.currentAvailableMemoryInBytes.get()});
            return -1L;
        }
        return size;
    }

    public MemoryPool getCorrespondingTaskMemoryPool(String threadName) {
        return this.threadName2TaskMemoryPoolMap.getOrDefault(threadName, null);
    }

    public void bindCorrespondingTaskMemoryPool(String threadName, TaskMemoryPool memoryPool) {
        this.threadName2TaskMemoryPoolMap.computeIfAbsent(threadName, key -> memoryPool);
    }

    public void removeCorrespondingTaskMemoryPool(String threadName) {
        this.threadName2TaskMemoryPoolMap.remove(threadName);
    }

    public Queue<MemoryPool> getCurrentQueryMemoryPools() {
        return new PriorityQueue<MemoryPool>(this.queryMemoryPools);
    }

    public AtomicLong getCurrentOnHeapAllocatedMemoryInBytes() {
        return this.currentOnHeapAllocatedMemoryInBytes;
    }

    public AtomicLong getCurrentOffHeapAllocatedMemoryInBytes() {
        return this.currentOffHeapAllocatedMemoryInBytes;
    }

    public static void setMemoryMode(MemoryMode conf) {
        MEMORY_MODE = conf;
    }

    public static MemoryMode getMemoryMode() {
        return MEMORY_MODE;
    }

    public static void setMaxMemoryCapacityInBytes(long maxMemoryCapacityInBytes) {
        MAX_MEMORY_CAPACITY_IN_BYTES = maxMemoryCapacityInBytes;
    }

    public static void setMaxMemoryCapacityForOneQuery(long maxMemoryCapacityForOneQuery) {
        MAX_MEMORY_CAPACITY_FOR_ONE_QUERY = maxMemoryCapacityForOneQuery;
    }

    @TestOnly
    public AtomicLong getCurrentAvailableMemoryInBytes() {
        return this.currentAvailableMemoryInBytes;
    }

    public static MemoryManager getInstance() {
        return MemoryManagerHolder.INSTANCE;
    }

    public static enum MemoryMode {
        ENABLE_OFF_HEAP_MANAGEMENT("off-heap"),
        ENABLE_ON_HEAP_MANAGEMENT("on-heap"),
        DISABLE_MEMORY_MANAGEMENT("disable");

        private final String value;

        private MemoryMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static MemoryMode fromValue(String value) {
            if (value.equalsIgnoreCase(ENABLE_ON_HEAP_MANAGEMENT.getValue())) {
                return ENABLE_ON_HEAP_MANAGEMENT;
            }
            if (value.equalsIgnoreCase(ENABLE_OFF_HEAP_MANAGEMENT.getValue())) {
                return ENABLE_OFF_HEAP_MANAGEMENT;
            }
            return DISABLE_MEMORY_MANAGEMENT;
        }
    }

    private static class MemoryManagerHolder {
        private static final MemoryManager INSTANCE = new MemoryManager();

        private MemoryManagerHolder() {
        }
    }
}

