/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.job.algorithm.Algorithm;
import org.apache.hugegraph.job.algorithm.CountEdgeAlgorithm;
import org.apache.hugegraph.job.algorithm.CountVertexAlgorithm;
import org.apache.hugegraph.job.algorithm.SubgraphStatAlgorithm;
import org.apache.hugegraph.job.algorithm.cent.BetweennessCentralityAlgorithm;
import org.apache.hugegraph.job.algorithm.cent.BetweennessCentralityAlgorithmV2;
import org.apache.hugegraph.job.algorithm.cent.ClosenessCentralityAlgorithm;
import org.apache.hugegraph.job.algorithm.cent.ClosenessCentralityAlgorithmV2;
import org.apache.hugegraph.job.algorithm.cent.DegreeCentralityAlgorithm;
import org.apache.hugegraph.job.algorithm.cent.EigenvectorCentralityAlgorithm;
import org.apache.hugegraph.job.algorithm.cent.StressCentralityAlgorithm;
import org.apache.hugegraph.job.algorithm.cent.StressCentralityAlgorithmV2;
import org.apache.hugegraph.job.algorithm.comm.ClusterCoefficientAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.KCoreAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.LouvainAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.LpaAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.TriangleCountAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.WeakConnectedComponent;
import org.apache.hugegraph.job.algorithm.path.RingsDetectAlgorithm;
import org.apache.hugegraph.job.algorithm.rank.PageRankAlgorithm;
import org.apache.hugegraph.job.algorithm.similarity.FusiformSimilarityAlgorithm;
import org.apache.hugegraph.util.E;

public class AlgorithmPool {
    private static final AlgorithmPool INSTANCE = new AlgorithmPool();
    private final Map<String, Algorithm> algorithms = new ConcurrentHashMap<String, Algorithm>();

    public Algorithm register(Algorithm algo) {
        assert (!this.algorithms.containsKey(algo.name()));
        return this.algorithms.put(algo.name(), algo);
    }

    public Algorithm find(String name) {
        return this.algorithms.get(name);
    }

    public Algorithm get(String name) {
        Algorithm algorithm = this.algorithms.get(name);
        E.checkArgument((algorithm != null ? 1 : 0) != 0, (String)"Not found algorithm '%s'", (Object[])new Object[]{name});
        return algorithm;
    }

    public static AlgorithmPool instance() {
        return INSTANCE;
    }

    static {
        INSTANCE.register(new CountVertexAlgorithm());
        INSTANCE.register(new CountEdgeAlgorithm());
        INSTANCE.register(new DegreeCentralityAlgorithm());
        INSTANCE.register(new StressCentralityAlgorithm());
        INSTANCE.register(new BetweennessCentralityAlgorithm());
        INSTANCE.register(new ClosenessCentralityAlgorithm());
        INSTANCE.register(new EigenvectorCentralityAlgorithm());
        INSTANCE.register(new TriangleCountAlgorithm());
        INSTANCE.register(new ClusterCoefficientAlgorithm());
        INSTANCE.register(new LpaAlgorithm());
        INSTANCE.register(new LouvainAlgorithm());
        INSTANCE.register(new WeakConnectedComponent());
        INSTANCE.register(new FusiformSimilarityAlgorithm());
        INSTANCE.register(new RingsDetectAlgorithm());
        INSTANCE.register(new KCoreAlgorithm());
        INSTANCE.register(new PageRankAlgorithm());
        INSTANCE.register(new SubgraphStatAlgorithm());
        INSTANCE.register(new StressCentralityAlgorithmV2());
        INSTANCE.register(new BetweennessCentralityAlgorithmV2());
        INSTANCE.register(new ClosenessCentralityAlgorithmV2());
    }
}

