/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job;

import java.util.Map;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.job.SysJob;
import org.apache.hugegraph.job.computer.Computer;
import org.apache.hugegraph.job.computer.ComputerPool;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;

public class ComputerJob
extends SysJob<Object> {
    public static final String COMPUTER = "computer";

    public static boolean check(String name, Map<String, Object> parameters) {
        Computer computer = ComputerPool.instance().find(name);
        if (computer == null) {
            return false;
        }
        computer.checkParameters(parameters);
        return true;
    }

    public String computerConfigPath() {
        return (String)this.params().configuration().get(CoreOptions.COMPUTER_CONFIG);
    }

    @Override
    public String type() {
        return COMPUTER;
    }

    @Override
    public Object execute() throws Exception {
        String input = this.task().input();
        E.checkArgumentNotNull((Object)input, (String)"The input can't be null", (Object[])new Object[0]);
        Map map = JsonUtil.fromJson(input, Map.class);
        Object value = map.get(COMPUTER);
        E.checkArgument((boolean)(value instanceof String), (String)"Invalid computer name '%s'", (Object[])new Object[]{value});
        String name = (String)value;
        value = map.get("parameters");
        E.checkArgument((boolean)(value instanceof Map), (String)"Invalid computer parameters '%s'", (Object[])new Object[]{value});
        Map parameters = (Map)value;
        ComputerPool pool = ComputerPool.instance();
        Computer computer = pool.find(name);
        E.checkArgument((computer != null ? 1 : 0) != 0, (String)"There is no computer method named '%s'", (Object[])new Object[]{name});
        return computer.call(this, parameters);
    }
}

