/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job;

import java.util.Map;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.Algorithm;
import org.apache.hugegraph.job.algorithm.AlgorithmPool;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;

public class AlgorithmJob
extends UserJob<Object> {
    public static final String TASK_TYPE = "algorithm";

    public static boolean check(String name, Map<String, Object> parameters) {
        Algorithm algorithm = AlgorithmPool.instance().find(name);
        if (algorithm == null) {
            return false;
        }
        algorithm.checkParameters(parameters);
        return true;
    }

    @Override
    public String type() {
        return TASK_TYPE;
    }

    @Override
    public Object execute() throws Exception {
        String input = this.task().input();
        E.checkArgumentNotNull((Object)input, (String)"The input can't be null", (Object[])new Object[0]);
        Map map = JsonUtil.fromJson(input, Map.class);
        Object value = map.get(TASK_TYPE);
        E.checkArgument((boolean)(value instanceof String), (String)"Invalid algorithm name '%s'", (Object[])new Object[]{value});
        String name = (String)value;
        value = map.get("parameters");
        E.checkArgument((boolean)(value instanceof Map), (String)"Invalid algorithm parameters '%s'", (Object[])new Object[]{value});
        Map parameters = (Map)value;
        AlgorithmPool pool = AlgorithmPool.instance();
        Algorithm algorithm = pool.find(name);
        E.checkArgument((algorithm != null ? 1 : 0) != 0, (String)"There is no algorithm named '%s'", (Object[])new Object[]{name});
        return algorithm.call(this, parameters);
    }
}

