/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.page;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageIds;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.iterator.CIter;
import org.apache.hugegraph.iterator.Metadatable;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public abstract class IdHolder {
    protected final Query query;
    protected boolean exhausted;

    public IdHolder(Query query) {
        E.checkNotNull((Object)query, (String)"query");
        this.query = query;
        this.exhausted = false;
    }

    public Query query() {
        return this.query;
    }

    public boolean keepOrder() {
        return false;
    }

    public String toString() {
        return String.format("%s{origin:%s,final:%s}", this.getClass().getSimpleName(), this.query.originQuery(), this.query);
    }

    public abstract boolean paging();

    public abstract Set<Id> all();

    public abstract PageIds fetchNext(String var1, long var2);

    public static class BatchIdHolder
    extends IdHolder
    implements CIter<IdHolder> {
        private final Iterator<BackendEntry> entries;
        private final Function<Long, Set<Id>> fetcher;
        private long count;
        private PageIds currentBatch;

        public BatchIdHolder(ConditionQuery query, Iterator<BackendEntry> entries, Function<Long, Set<Id>> fetcher) {
            super(query);
            this.entries = entries;
            this.fetcher = fetcher;
            this.count = 0L;
            this.currentBatch = null;
        }

        @Override
        public boolean paging() {
            return false;
        }

        public boolean hasNext() {
            if (this.currentBatch != null) {
                return true;
            }
            if (this.exhausted) {
                return false;
            }
            boolean hasNext = this.entries.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        public IdHolder next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this;
        }

        @Override
        public PageIds fetchNext(String page, long batchSize) {
            long remaining;
            E.checkArgument((page == null ? 1 : 0) != 0, (String)"Not support page parameter by BatchIdHolder", (Object[])new Object[0]);
            E.checkArgument((batchSize >= 0L ? 1 : 0) != 0, (String)"Invalid batch size value: %s", (Object[])new Object[]{batchSize});
            if (this.currentBatch != null) {
                return this.getFromCurrentBatch(batchSize);
            }
            if (!this.query.noLimit() && (remaining = this.remaining()) < batchSize) {
                batchSize = remaining;
            }
            assert (batchSize >= 0L) : batchSize;
            Set<Id> ids = this.fetcher.apply(batchSize);
            int size = ids.size();
            this.count += (long)size;
            if ((long)size < batchSize || size == 0) {
                this.close();
            }
            if (size == 0) {
                return PageIds.EMPTY;
            }
            return new PageIds(ids, PageState.EMPTY);
        }

        @Override
        public Set<Id> all() {
            try {
                Set<Id> ids = this.fetcher.apply(this.remaining());
                if (this.currentBatch != null) {
                    ids.addAll(this.getFromCurrentBatch(Long.MAX_VALUE).ids());
                }
                this.count += (long)ids.size();
                Set<Id> set = ids;
                return set;
            }
            finally {
                this.close();
            }
        }

        public PageIds peekNext(long size) {
            E.checkArgument((this.currentBatch == null ? 1 : 0) != 0, (String)"Can't call peekNext() twice", (Object[])new Object[0]);
            this.currentBatch = this.fetchNext(null, size);
            return this.currentBatch;
        }

        private PageIds getFromCurrentBatch(long batchSize) {
            assert (this.currentBatch != null);
            PageIds result = this.currentBatch;
            this.currentBatch = null;
            return result;
        }

        private long remaining() {
            if (this.query.noLimit()) {
                return Long.MAX_VALUE;
            }
            return this.query.total() - this.count;
        }

        public void close() {
            if (this.exhausted) {
                return;
            }
            this.exhausted = true;
            CloseableIterator.closeIterator(this.entries);
        }

        public Object metadata(String meta, Object ... args) {
            E.checkState((boolean)(this.entries instanceof Metadatable), (String)"Invalid iterator for Metadatable: %s", (Object[])new Object[]{this.entries.getClass()});
            return ((Metadatable)this.entries).metadata(meta, args);
        }
    }

    public static class PagingIdHolder
    extends IdHolder {
        private final Function<ConditionQuery, PageIds> fetcher;

        public PagingIdHolder(ConditionQuery query, Function<ConditionQuery, PageIds> fetcher) {
            super(query.copy());
            E.checkArgument((boolean)query.paging(), (String)"Query '%s' must include page info", (Object[])new Object[]{query});
            this.fetcher = fetcher;
        }

        @Override
        public boolean paging() {
            return true;
        }

        @Override
        public PageIds fetchNext(String page, long pageSize) {
            if (this.exhausted) {
                return PageIds.EMPTY;
            }
            this.query.page(page);
            this.query.limit(pageSize);
            PageIds result = this.fetcher.apply((ConditionQuery)this.query);
            assert (result != null);
            if ((long)result.ids().size() < pageSize || result.page() == null) {
                this.exhausted = true;
            }
            return result;
        }

        @Override
        public Set<Id> all() {
            throw new NotImplementedException("PagingIdHolder.all");
        }
    }

    public static class FixedIdHolder
    extends IdHolder {
        private final Set<Id> ids;

        public FixedIdHolder(Query query, Set<Id> ids) {
            super(query);
            E.checkArgumentNotNull(ids, (String)"The ids can't be null", (Object[])new Object[0]);
            this.ids = ids;
        }

        @Override
        public boolean paging() {
            return false;
        }

        @Override
        public Set<Id> all() {
            return this.ids;
        }

        @Override
        public PageIds fetchNext(String page, long pageSize) {
            throw new NotImplementedException("FixedIdHolder.fetchNext");
        }
    }
}

