/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.wltea.analyzer.core.IKSegmenter;
import org.wltea.analyzer.core.Lexeme;

public class IKAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.of((Object)"smart", (Object)"max_word");
    private final boolean smartSegMode;

    public IKAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for ikanalyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        this.smartSegMode = SUPPORT_MODES.get(0).equals(mode);
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        IKSegmenter ik = new IKSegmenter((Reader)new StringReader(text), this.smartSegMode);
        try {
            Lexeme word;
            while ((word = ik.next()) != null) {
                result.add(word.getLexemeText());
            }
        }
        catch (Exception e) {
            throw new HugeException("IKAnalyzer segment text '%s' failed", (Throwable)e, text);
        }
        return result;
    }
}

