/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import com.hankcs.hanlp.seg.Dijkstra.DijkstraSegment;
import com.hankcs.hanlp.seg.NShort.NShortSegment;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.tokenizer.IndexTokenizer;
import com.hankcs.hanlp.tokenizer.NLPTokenizer;
import com.hankcs.hanlp.tokenizer.SpeedTokenizer;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class HanLPAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.builder().add((Object)"standard").add((Object)"nlp").add((Object)"index").add((Object)"nShort").add((Object)"shortest").add((Object)"speed").build();
    private static final Segment N_SHORT_SEGMENT = new NShortSegment().enableCustomDictionary(false).enablePlaceRecognize(true).enableOrganizationRecognize(true);
    private static final Segment DIJKSTRA_SEGMENT = new DijkstraSegment().enableCustomDictionary(false).enablePlaceRecognize(true).enableOrganizationRecognize(true);
    private final String tokenizer;

    public HanLPAnalyzer(String mode) {
        if (!SUPPORT_MODES.contains(mode)) {
            throw new ConfigException("Unsupported segment mode '%s' for hanlp analyzer, the available values are %s", new Object[]{mode, SUPPORT_MODES});
        }
        this.tokenizer = mode;
    }

    @Override
    public Set<String> segment(String text) {
        List terms;
        switch (this.tokenizer) {
            case "standard": {
                terms = StandardTokenizer.segment((String)text);
                break;
            }
            case "nlp": {
                terms = NLPTokenizer.segment((String)text);
                break;
            }
            case "index": {
                terms = IndexTokenizer.segment((String)text);
                break;
            }
            case "nShort": {
                terms = N_SHORT_SEGMENT.seg(text);
                break;
            }
            case "shortest": {
                terms = DIJKSTRA_SEGMENT.seg(text);
                break;
            }
            case "speed": {
                terms = SpeedTokenizer.segment((String)text);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported segment mode '%s'", this.tokenizer));
            }
        }
        assert (terms != null);
        Set result = InsertionOrderUtil.newSet();
        for (Term term : terms) {
            result.add(term.word);
        }
        return result;
    }
}

