/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.StandardHugeGraph;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.traversal.algorithm.OltpTraverser;
import org.apache.hugegraph.type.define.SerialEnum;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

public class HugeFactory {
    public static final String SYS_GRAPH = Graph.Hidden.hide((String)"sys_graph");
    private static final Logger LOG = Log.logger(HugeFactory.class);
    private static final String NAME_REGEX = "^[A-Za-z][A-Za-z0-9_]{0,47}$";
    private static final Map<String, HugeGraph> GRAPHS = new HashMap<String, HugeGraph>();
    private static final AtomicBoolean SHUT_DOWN = new AtomicBoolean(false);
    private static final Thread SHUT_DOWN_HOOK = new Thread(() -> {
        LOG.info("HugeGraph is shutting down");
        HugeFactory.shutdown(30L, true);
    }, "hugegraph-shutdown");

    public static synchronized HugeGraph open(Configuration config) {
        HugeConfig conf = config instanceof HugeConfig ? (HugeConfig)config : new HugeConfig(config);
        return HugeFactory.open(conf);
    }

    public static synchronized HugeGraph open(HugeConfig config) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            File configFile = config.file();
            String configFileName = configFile == null ? config.toString() : configFile.getName();
            sm.checkRead(configFileName);
        }
        String name = (String)config.get(CoreOptions.STORE);
        HugeFactory.checkGraphName(name, "graph config(like hugegraph.properties)");
        String graphSpace = (String)config.get(CoreOptions.GRAPH_SPACE);
        name = name.toLowerCase();
        String spaceGraphName = graphSpace + "-" + name;
        HugeGraph graph = GRAPHS.get(spaceGraphName);
        if (graph == null || graph.closed()) {
            graph = new StandardHugeGraph(config);
            GRAPHS.put(spaceGraphName, graph);
        } else {
            String backend = (String)config.get(CoreOptions.BACKEND);
            E.checkState((boolean)backend.equalsIgnoreCase(graph.backend()), (String)"Graph name '%s' has been used by backend '%s'", (Object[])new Object[]{name, graph.backend()});
        }
        return graph;
    }

    public static HugeGraph open(String path) {
        return HugeFactory.open((Configuration)HugeFactory.getLocalConfig(path));
    }

    public static HugeGraph open(URL url) {
        return HugeFactory.open((Configuration)HugeFactory.getRemoteConfig(url));
    }

    public static void remove(HugeGraph graph) {
        String spaceGraphName = graph.spaceGraphName();
        GRAPHS.remove(spaceGraphName);
    }

    public static void checkGraphName(String name, String configFile) {
        E.checkArgument((SYS_GRAPH.equals(name) || name.matches(NAME_REGEX) ? 1 : 0) != 0, (String)"Invalid graph name '%s' in %s, valid graph name is up to 48 alpha-numeric characters and underscores and only letters are supported as first letter. Note: letter is case insensitive", (Object[])new Object[]{name, configFile});
    }

    public static PropertiesConfiguration getLocalConfig(String path) {
        File file = new File(path);
        E.checkArgument((file.exists() && file.isFile() && file.canRead() ? 1 : 0) != 0, (String)"Please specify a proper config file rather than: %s", (Object[])new Object[]{file.toString()});
        try {
            return new Configurations().properties(file);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Unable to load config file: %s", (Throwable)e, path);
        }
    }

    public static PropertiesConfiguration getRemoteConfig(URL url) {
        try {
            return new Configurations().properties(url);
        }
        catch (ConfigurationException e) {
            throw new HugeException("Unable to load remote config file: %s", (Throwable)e, url);
        }
    }

    public static void shutdown(long timeout) {
        HugeFactory.shutdown(timeout, false);
    }

    public static void shutdown(long timeout, boolean ignoreException) {
        if (!SHUT_DOWN.compareAndSet(false, true)) {
            return;
        }
        try {
            if (!EventHub.destroy((long)timeout)) {
                throw new TimeoutException(timeout + "s");
            }
            TaskManager.instance().shutdown(timeout);
            OltpTraverser.destroy();
        }
        catch (Throwable e) {
            LOG.error("Error while shutdown", e);
            SHUT_DOWN.compareAndSet(true, false);
            if (ignoreException) {
                return;
            }
            throw new HugeException("Failed to shutdown", e);
        }
        LOG.info("HugeFactory shutdown");
    }

    public static void removeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(SHUT_DOWN_HOOK);
    }

    static {
        SerialEnum.registerInternalEnums();
        HugeGraph.registerTraversalStrategies(StandardHugeGraph.class);
        Runtime.getRuntime().addShutdownHook(SHUT_DOWN_HOOK);
    }
}

