/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AddressHolder;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.ConcurrentHashSet;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Extension(value="singleGroup")
public class SingleGroupAddressHolder
extends AddressHolder {
    protected ProviderGroup directUrlGroup;
    protected ProviderGroup registryGroup;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock rLock = this.lock.readLock();
    private Lock wLock = this.lock.writeLock();

    protected SingleGroupAddressHolder(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
        this.directUrlGroup = new ProviderGroup("_DIRECT");
        this.registryGroup = new ProviderGroup();
    }

    @Override
    public List<ProviderInfo> getProviderInfos(String groupName) {
        this.rLock.lock();
        try {
            ArrayList<ProviderInfo> arrayList = new ArrayList<ProviderInfo>(this.getProviderGroup(groupName).getProviderInfos());
            return arrayList;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public ProviderGroup getProviderGroup(String groupName) {
        this.rLock.lock();
        try {
            ProviderGroup providerGroup = "_DIRECT".equals(groupName) ? this.directUrlGroup : this.registryGroup;
            return providerGroup;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public List<ProviderGroup> getProviderGroups() {
        this.rLock.lock();
        try {
            ArrayList<ProviderGroup> list = new ArrayList<ProviderGroup>();
            list.add(this.registryGroup);
            list.add(this.directUrlGroup);
            ArrayList<ProviderGroup> arrayList = list;
            return arrayList;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public int getAllProviderSize() {
        this.rLock.lock();
        try {
            int n = this.directUrlGroup.size() + this.registryGroup.size();
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public void addProvider(ProviderGroup providerGroup) {
        if (ProviderHelper.isEmpty(providerGroup)) {
            return;
        }
        this.wLock.lock();
        try {
            this.getProviderGroup(providerGroup.getName()).addAll(providerGroup.getProviderInfos());
        }
        finally {
            this.wLock.unlock();
        }
    }

    @Override
    public void removeProvider(ProviderGroup providerGroup) {
        if (ProviderHelper.isEmpty(providerGroup)) {
            return;
        }
        this.wLock.lock();
        try {
            this.getProviderGroup(providerGroup.getName()).removeAll(providerGroup.getProviderInfos());
        }
        finally {
            this.wLock.unlock();
        }
    }

    @Override
    public void updateProviders(ProviderGroup providerGroup) {
        this.wLock.lock();
        try {
            this.getProviderGroup(providerGroup.getName()).setProviderInfos(new ArrayList<ProviderInfo>(providerGroup.getProviderInfos()));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllProviders(List<ProviderGroup> providerGroups) {
        ConcurrentHashSet<ProviderInfo> tmpDirectUrl = new ConcurrentHashSet<ProviderInfo>();
        ConcurrentHashSet<ProviderInfo> tmpRegistry = new ConcurrentHashSet<ProviderInfo>();
        for (ProviderGroup providerGroup : providerGroups) {
            if (ProviderHelper.isEmpty(providerGroup)) continue;
            if ("_DIRECT".equals(providerGroup.getName())) {
                tmpDirectUrl.addAll(providerGroup.getProviderInfos());
                continue;
            }
            tmpRegistry.addAll(providerGroup.getProviderInfos());
        }
        this.wLock.lock();
        try {
            this.directUrlGroup.setProviderInfos(new ArrayList<ProviderInfo>(tmpDirectUrl));
            this.registryGroup.setProviderInfos(new ArrayList<ProviderInfo>(tmpRegistry));
        }
        finally {
            this.wLock.unlock();
        }
    }
}

