/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.IdPrefixQuery;
import org.apache.hugegraph.backend.query.IdRangeQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.BinaryBackendEntry;
import org.apache.hugegraph.backend.serializer.BinaryEntryIterator;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.backend.store.hstore.HstoreSessions;
import org.apache.hugegraph.backend.store.hstore.HstoreSessionsImpl;
import org.apache.hugegraph.backend.store.hstore.HstoreStore;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;

public class HstoreTable
extends BackendTable<HstoreSessions.Session, BackendEntry> {
    private static final Logger LOG = Log.logger(HstoreStore.class);
    private final HstoreShardSplitter shardSpliter;
    Function<BackendEntry, byte[]> ownerDelegate = this::getOwner;
    Function<Id, byte[]> ownerByIdDelegate = this::getOwnerId;
    BiFunction<HugeType, Id, byte[]> ownerByQueryDelegate = this::getOwnerId;
    Supplier<byte[]> ownerScanDelegate = () -> HgStoreClientConst.ALL_PARTITION_OWNER;

    public HstoreTable(String database, String table) {
        super(String.format("%s+%s", database, table));
        this.shardSpliter = new HstoreShardSplitter(this.table());
    }

    public static ConditionQuery removeDirectionCondition(ConditionQuery conditionQuery) {
        Collection conditions = conditionQuery.conditions();
        ArrayList<Condition> newConditions = new ArrayList<Condition>();
        for (Condition condition : conditions) {
            if (HstoreTable.direction(condition)) continue;
            newConditions.add(condition);
        }
        if (newConditions.size() > 0) {
            conditionQuery.resetConditions(newConditions);
            return conditionQuery;
        }
        return null;
    }

    private static boolean direction(Condition condition) {
        boolean direction = true;
        List relations = condition.relations();
        for (Condition.Relation r : relations) {
            if (r.key().equals(HugeKeys.DIRECTION)) continue;
            direction = false;
            break;
        }
        return direction;
    }

    protected static BackendEntryIterator newEntryIterator(BackendEntry.BackendColumnIterator cols, Query query) {
        return new BinaryEntryIterator((BackendEntry.BackendIterator)cols, query, (entry, col) -> {
            if (entry == null || !entry.belongToMe(col)) {
                HugeType type = query.resultType();
                entry = new BinaryBackendEntry(type, col.name);
            }
            entry.columns(col);
            return entry;
        });
    }

    protected static BackendEntryIterator newEntryIteratorOlap(BackendEntry.BackendColumnIterator cols, Query query, boolean isOlap) {
        return new BinaryEntryIterator((BackendEntry.BackendIterator)cols, query, (entry, col) -> {
            if (entry == null || !entry.belongToMe(col)) {
                HugeType type = query.resultType();
                entry = new BinaryBackendEntry(type, col.name, false, isOlap);
            }
            entry.columns(col);
            return entry;
        });
    }

    public static String bytes2String(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            String st = String.format("%02x", b);
            result.append(st);
        }
        return result.toString();
    }

    protected void registerMetaHandlers() {
        this.registerMetaHandler("splits", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            long splitSize = (Long)args[0];
            return this.shardSpliter.getSplits((HstoreSessions.Session)session, splitSize);
        });
    }

    public void init(HstoreSessions.Session session) {
    }

    public void clear(HstoreSessions.Session session) {
    }

    public boolean isOlap() {
        return false;
    }

    private byte[] getOwner(BackendEntry entry) {
        if (entry == null) {
            return HgStoreClientConst.ALL_PARTITION_OWNER;
        }
        Id id = entry.type().isIndex() ? entry.id() : entry.originId();
        return this.getOwnerId(id);
    }

    public Supplier<byte[]> getOwnerScanDelegate() {
        return this.ownerScanDelegate;
    }

    public byte[] getInsertEdgeOwner(BackendEntry entry) {
        Id id = entry.originId();
        id = ((EdgeId)id).ownerVertexId();
        return id.asBytes();
    }

    public byte[] getInsertOwner(BackendEntry entry) {
        Iterator iterator;
        if (entry.type().isLabelIndex() && entry.columns().size() == 1 && (iterator = entry.columns().iterator()).hasNext()) {
            BackendEntry.BackendColumn next = (BackendEntry.BackendColumn)iterator.next();
            return next.name;
        }
        Id id = entry.type().isIndex() ? entry.id() : entry.originId();
        return this.getOwnerId(id);
    }

    protected byte[] getOwnerId(Id id) {
        if (id instanceof BinaryBackendEntry.BinaryId) {
            id = ((BinaryBackendEntry.BinaryId)id).origin();
        }
        if (id != null && id.edge()) {
            id = ((EdgeId)id).ownerVertexId();
        }
        return id != null ? id.asBytes() : HgStoreClientConst.ALL_PARTITION_OWNER;
    }

    protected byte[] getOwnerId(HugeType type, Id id) {
        if (type.equals((Object)HugeType.VERTEX) || type.equals((Object)HugeType.EDGE) || type.equals((Object)HugeType.EDGE_OUT) || type.equals((Object)HugeType.EDGE_IN) || type.equals((Object)HugeType.COUNTER)) {
            return this.getOwnerId(id);
        }
        return HgStoreClientConst.ALL_PARTITION_OWNER;
    }

    public void insert(HstoreSessions.Session session, BackendEntry entry) {
        byte[] owner = entry.type().isEdge() ? this.getInsertEdgeOwner(entry) : this.getInsertOwner(entry);
        ArrayList columns = new ArrayList(entry.columns());
        for (int i = 0; i < columns.size(); ++i) {
            BackendEntry.BackendColumn col = (BackendEntry.BackendColumn)columns.get(i);
            session.put(this.table(), owner, col.name, col.value);
        }
    }

    public void insert(HstoreSessions.Session session, BackendEntry entry, boolean isEdge) {
        byte[] owner = isEdge ? this.getInsertEdgeOwner(entry) : this.getInsertOwner(entry);
        ArrayList columns = new ArrayList(entry.columns());
        for (int i = 0; i < columns.size(); ++i) {
            BackendEntry.BackendColumn col = (BackendEntry.BackendColumn)columns.get(i);
            session.put(this.table(), owner, col.name, col.value);
        }
    }

    public void delete(HstoreSessions.Session session, BackendEntry entry) {
        byte[] ownerKey = this.ownerDelegate.apply(entry);
        if (entry.columns().isEmpty()) {
            byte[] idBytes = entry.id().asBytes();
            session.delete(this.table(), ownerKey, idBytes);
        } else {
            for (BackendEntry.BackendColumn col : entry.columns()) {
                assert (entry.belongToMe(col)) : entry;
                session.delete(this.table(), ownerKey, col.name);
            }
        }
    }

    public void append(HstoreSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.insert(session, entry);
    }

    public void eliminate(HstoreSessions.Session session, BackendEntry entry) {
        assert (entry.columns().size() == 1);
        this.delete(session, entry);
    }

    public boolean queryExist(HstoreSessions.Session session, BackendEntry entry) {
        Id id = entry.id();
        try (BackendEntry.BackendColumnIterator iter = this.queryById(session, id);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    public Number queryNumber(HstoreSessions.Session session, Query query) {
        Aggregate aggregate = query.aggregateNotNull();
        if (aggregate.func() != Aggregate.AggregateFunc.COUNT) {
            throw new NotSupportException(aggregate.toString());
        }
        assert (aggregate.func() == Aggregate.AggregateFunc.COUNT);
        assert (query.noLimit());
        BackendEntry.BackendColumnIterator results = this.queryBy(session, query);
        if (results instanceof HstoreSessions.Countable) {
            return ((HstoreSessions.Countable)results).count();
        }
        return IteratorUtils.count((Iterator)results);
    }

    public Iterator<BackendEntry> query(HstoreSessions.Session session, Query query) {
        if (query.limit() == 0L && !query.noLimit()) {
            return Collections.emptyIterator();
        }
        return HstoreTable.newEntryIterator(this.queryBy(session, query), query);
    }

    public Iterator<BackendEntry> queryOlap(HstoreSessions.Session session, Query query) {
        if (query.limit() == 0L && !query.noLimit()) {
            return Collections.emptyIterator();
        }
        return HstoreTable.newEntryIteratorOlap(this.queryBy(session, query), query, true);
    }

    public List<Iterator<BackendEntry>> query(HstoreSessions.Session session, List<IdPrefixQuery> queries, String tableName) {
        List<BackendEntry.BackendColumnIterator> queryByPrefixList = this.queryByPrefixList(session, queries, tableName);
        LinkedList<Iterator<BackendEntry>> iterators = new LinkedList<Iterator<BackendEntry>>();
        for (int i = 0; i < queryByPrefixList.size(); ++i) {
            IdPrefixQuery q = queries.get(i).copy();
            q.capacity(-1L);
            q.limit(Long.MAX_VALUE);
            BackendEntryIterator iterator = HstoreTable.newEntryIterator(queryByPrefixList.get(i), (Query)q);
            iterators.add((Iterator<BackendEntry>)iterator);
        }
        return iterators;
    }

    public BackendEntry.BackendIterator<Iterator<BackendEntry>> query(HstoreSessions.Session session, final Iterator<IdPrefixQuery> queries, String tableName) {
        final IdPrefixQuery[] first = new IdPrefixQuery[]{queries.next()};
        int type = first[0].withProperties() ? 0 : 64;
        final IdPrefixQuery queryTmpl = first[0].copy();
        queryTmpl.capacity(-1L);
        queryTmpl.limit(Long.MAX_VALUE);
        ConditionQuery originQuery = (ConditionQuery)first[0].originQuery();
        if (originQuery != null) {
            originQuery = this.prepareConditionQueryList(originQuery);
        }
        byte[] queryBytes = originQuery == null ? null : originQuery.bytes();
        final BackendEntry.BackendIterator<BackendEntry.BackendColumnIterator> it = session.scan(tableName, new Iterator<HgOwnerKey>(){

            @Override
            public boolean hasNext() {
                if (first[0] != null) {
                    return true;
                }
                return queries.hasNext();
            }

            @Override
            public HgOwnerKey next() {
                IdPrefixQuery query = first[0] != null ? first[0] : (IdPrefixQuery)queries.next();
                first[0] = null;
                byte[] prefix = HstoreTable.this.ownerByQueryDelegate.apply(query.resultType(), query.prefix());
                return HgOwnerKey.of((byte[])prefix, (byte[])query.prefix().asBytes());
            }
        }, type, (Query)first[0], queryBytes);
        return new BackendEntry.BackendIterator<Iterator<BackendEntry>>(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public Iterator<BackendEntry> next() {
                BackendEntryIterator iterator = HstoreTable.newEntryIterator((BackendEntry.BackendColumnIterator)it.next(), (Query)queryTmpl);
                return iterator;
            }

            public void close() {
                it.close();
            }

            public byte[] position() {
                return new byte[0];
            }
        };
    }

    protected BackendEntry.BackendColumnIterator queryBy(HstoreSessions.Session session, Query query) {
        if (query.empty()) {
            return this.queryAll(session, query);
        }
        if (query instanceof IdPrefixQuery) {
            IdPrefixQuery pq = (IdPrefixQuery)query;
            return this.queryByPrefix(session, pq);
        }
        if (query instanceof IdRangeQuery) {
            IdRangeQuery rq = (IdRangeQuery)query;
            return this.queryByRange(session, rq);
        }
        if (query.conditions().isEmpty()) {
            assert (!query.ids().isEmpty());
            if (query.ids().size() == 1) {
                return this.getById(session, (Id)query.ids().iterator().next());
            }
            LinkedList<HgOwnerKey> hgOwnerKeys = new LinkedList<HgOwnerKey>();
            for (Id id : query.ids()) {
                hgOwnerKeys.add(HgOwnerKey.of((byte[])this.ownerByIdDelegate.apply(id), (byte[])id.asBytes()));
            }
            BackendEntry.BackendColumnIterator withBatch = session.getWithBatch(this.table(), hgOwnerKeys);
            return BackendEntry.BackendColumnIterator.wrap((Iterator)withBatch);
        }
        ConditionQuery cq = (ConditionQuery)query;
        return this.queryByCond(session, cq);
    }

    protected BackendEntry.BackendColumnIterator queryAll(HstoreSessions.Session session, Query query) {
        if (query.paging()) {
            PageState page = PageState.fromString((String)query.page());
            byte[] ownerKey = this.getOwnerScanDelegate().get();
            int scanType = 0x80 | (query.withProperties() ? 0 : 64);
            byte[] queryBytes = query instanceof ConditionQuery ? ((ConditionQuery)query).bytes() : null;
            return session.scan(this.table(), ownerKey, ownerKey, null, null, scanType, queryBytes, page.position());
        }
        return session.scan(this.table(), query instanceof ConditionQuery ? ((ConditionQuery)query).bytes() : null);
    }

    protected BackendEntry.BackendColumnIterator queryById(HstoreSessions.Session session, Id id) {
        return session.scan(this.table(), this.ownerByIdDelegate.apply(id), id.asBytes());
    }

    protected BackendEntry.BackendColumnIterator getById(HstoreSessions.Session session, Id id) {
        byte[] value = session.get(this.table(), this.ownerByIdDelegate.apply(id), id.asBytes());
        if (value.length == 0) {
            return BackendEntry.BackendColumnIterator.empty();
        }
        BackendEntry.BackendColumn col = BackendEntry.BackendColumn.of((byte[])id.asBytes(), (byte[])value);
        return BackendEntry.BackendColumnIterator.iterator((BackendEntry.BackendColumn)col);
    }

    protected BackendEntry.BackendColumnIterator queryByPrefix(HstoreSessions.Session session, IdPrefixQuery query) {
        ConditionQuery originQuery;
        int type = query.inclusiveStart() ? 12 : 4;
        type |= 2;
        byte[] position = null;
        if (query.paging()) {
            position = PageState.fromString((String)query.page()).position();
        }
        if ((originQuery = (ConditionQuery)query.originQuery()) != null) {
            originQuery = this.prepareConditionQuery(originQuery);
        }
        byte[] ownerKeyFrom = this.ownerByQueryDelegate.apply(query.resultType(), query.start());
        byte[] ownerKeyTo = this.ownerByQueryDelegate.apply(query.resultType(), query.prefix());
        byte[] keyFrom = query.start().asBytes();
        if (query.paging()) {
            keyFrom = query.prefix().asBytes();
        }
        byte[] keyTo = query.prefix().asBytes();
        byte[] queryBytes = originQuery == null ? null : originQuery.bytes();
        return session.scan(this.table(), ownerKeyFrom, ownerKeyTo, keyFrom, keyTo, type, queryBytes, position);
    }

    protected List<BackendEntry.BackendColumnIterator> queryByPrefixList(HstoreSessions.Session session, List<IdPrefixQuery> queries, String tableName) {
        E.checkArgument((queries.size() > 0 ? 1 : 0) != 0, (String)"The size of queries must be greater than zero", (Object[])new Object[0]);
        IdPrefixQuery query = queries.get(0);
        int type = 0;
        LinkedList<HgOwnerKey> ownerKey = new LinkedList<HgOwnerKey>();
        queries.forEach(item -> {
            byte[] prefix = this.ownerByQueryDelegate.apply(item.resultType(), item.prefix());
            ownerKey.add(HgOwnerKey.of((byte[])prefix, (byte[])item.prefix().asBytes()));
        });
        ConditionQuery originQuery = (ConditionQuery)query.originQuery();
        if (originQuery != null) {
            originQuery = this.prepareConditionQueryList(originQuery);
        }
        byte[] queryBytes = originQuery == null ? null : originQuery.bytes();
        return session.scan(tableName, ownerKey, type, query.limit(), queryBytes);
    }

    private ConditionQuery prepareConditionQuery(ConditionQuery conditionQuery) {
        if (CollectionUtils.isEmpty((Collection)conditionQuery.userpropConditions())) {
            return null;
        }
        Collection conditions = conditionQuery.conditions();
        ArrayList<Condition> newConditions = new ArrayList<Condition>();
        for (Condition condition : conditions) {
            if (this.onlyOwnerVertex(condition)) continue;
            newConditions.add(condition);
        }
        if (newConditions.size() > 0) {
            conditionQuery.resetConditions(newConditions);
            return conditionQuery;
        }
        return null;
    }

    private ConditionQuery prepareConditionQueryList(ConditionQuery conditionQuery) {
        if (!conditionQuery.containsLabelOrUserpropRelation()) {
            return null;
        }
        Collection conditions = conditionQuery.conditions();
        ArrayList<Condition> newConditions = new ArrayList<Condition>();
        for (Condition condition : conditions) {
            if (this.onlyOwnerVertex(condition)) continue;
            newConditions.add(condition);
        }
        if (newConditions.size() > 0) {
            conditionQuery.resetConditions(newConditions);
            return conditionQuery;
        }
        return null;
    }

    private boolean onlyOwnerVertex(Condition condition) {
        boolean onlyOwnerVertex = true;
        List relations = condition.relations();
        for (Condition.Relation r : relations) {
            if (r.key().equals(HugeKeys.OWNER_VERTEX)) continue;
            onlyOwnerVertex = false;
            break;
        }
        return onlyOwnerVertex;
    }

    protected BackendEntry.BackendColumnIterator queryByRange(HstoreSessions.Session session, IdRangeQuery query) {
        int type;
        byte[] start = query.start().asBytes();
        byte[] end = query.end() == null ? null : query.end().asBytes();
        int n = type = query.inclusiveStart() ? 12 : 4;
        if (end != null) {
            type |= query.inclusiveEnd() ? 48 : 16;
        }
        Query origin = query.originQuery();
        byte[] position = null;
        if (query.paging() && !query.page().isEmpty()) {
            position = PageState.fromString((String)query.page()).position();
        }
        byte[] ownerStart = this.ownerByQueryDelegate.apply(query.resultType(), query.start());
        byte[] ownerEnd = this.ownerByQueryDelegate.apply(query.resultType(), query.end());
        if (origin instanceof ConditionQuery && (query.resultType().isEdge() || query.resultType().isVertex())) {
            ConditionQuery cq = (ConditionQuery)query.originQuery();
            return session.scan(this.table(), ownerStart, ownerEnd, start, end, type, cq.bytes(), position);
        }
        return session.scan(this.table(), ownerStart, ownerEnd, start, end, type, null, position);
    }

    protected BackendEntry.BackendColumnIterator queryByCond(HstoreSessions.Session session, ConditionQuery query) {
        if (query.containsScanCondition()) {
            E.checkArgument((query.relations().size() == 1 ? 1 : 0) != 0, (String)"Invalid scan with multi conditions: %s", (Object[])new Object[]{query});
            Condition.Relation scan = (Condition.Relation)query.relations().iterator().next();
            Shard shard = (Shard)scan.value();
            return this.queryByRange(session, shard, query);
        }
        return this.queryAll(session, (Query)query);
    }

    protected BackendEntry.BackendColumnIterator queryByRange(HstoreSessions.Session session, Shard shard, ConditionQuery query) {
        int type = 12;
        type |= 0x10;
        type |= 0x100;
        type |= query.withProperties() ? 0 : 64;
        int start = Integer.parseInt(StringUtils.isEmpty((CharSequence)shard.start()) ? "0" : shard.start());
        int end = Integer.parseInt(StringUtils.isEmpty((CharSequence)shard.end()) ? "0" : shard.end());
        byte[] queryBytes = query.bytes();
        String page = query.page();
        if (page != null && !page.isEmpty()) {
            byte[] position = PageState.fromString((String)page).position();
            return session.scan(this.table(), start, end, type, queryBytes, position);
        }
        return session.scan(this.table(), start, end, type, queryBytes);
    }

    private static class HstoreShardSplitter
    extends BackendTable.ShardSplitter<HstoreSessions.Session> {
        public HstoreShardSplitter(String table) {
            super(table);
        }

        public List<Shard> getSplits(HstoreSessions.Session session, long splitSize) {
            E.checkArgument((splitSize >= 0x100000L ? 1 : 0) != 0, (String)"The split-size must be >= %s bytes, but got %s", (Object[])new Object[]{0x100000, splitSize});
            ArrayList<Shard> splits = new ArrayList<Shard>();
            try {
                PDClient pdClient = HstoreSessionsImpl.getDefaultPdClient();
                List partitions = pdClient.getPartitions(0L, session.getGraphName());
                for (Metapb.Partition partition : partitions) {
                    String start = String.valueOf(partition.getStartKey());
                    String end = String.valueOf(partition.getEndKey());
                    splits.add(new Shard(start, end, 0L));
                }
            }
            catch (PDException e) {
                e.printStackTrace();
            }
            return splits.size() != 0 ? splits : super.getSplits((BackendSession)session, splitSize);
        }

        public long estimateDataSize(HstoreSessions.Session session) {
            return 1L;
        }

        public long estimateNumKeys(HstoreSessions.Session session) {
            return 1L;
        }

        public byte[] position(String position) {
            if ("".equals(position)) {
                return null;
            }
            return StringEncoding.decodeBase64((String)position);
        }
    }
}

