/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.client.HgStoreNodePartitioner;
import org.apache.hugegraph.store.client.query.StreamKvIterator;
import org.apache.hugegraph.store.query.QueryTypeParam;
import org.apache.hugegraph.structure.BaseElement;

public class StreamStrictOrderIterator<E>
implements HgKvIterator<E> {
    private final Iterator<QueryTypeParam> ids;
    private final Map<String, StreamKvIterator<E>> iteratorMap = new HashMap<String, StreamKvIterator<E>>();
    private E data;
    private final String graph;
    private final HgStoreNodePartitioner nodePartitioner;

    public StreamStrictOrderIterator(List<QueryTypeParam> ids, List<HgKvIterator<E>> iteratorList, String graph, HgStoreNodePartitioner nodePartitioner) {
        this.ids = ids.iterator();
        for (HgKvIterator<E> itr : iteratorList) {
            StreamKvIterator itr2 = (StreamKvIterator)itr;
            this.iteratorMap.put(itr2.getAddress(), itr2);
        }
        this.graph = graph;
        this.nodePartitioner = nodePartitioner;
    }

    @Override
    public byte[] key() {
        return new byte[0];
    }

    @Override
    public byte[] value() {
        return new byte[0];
    }

    @Override
    public void close() {
        for (StreamKvIterator<E> itr : this.iteratorMap.values()) {
            itr.close();
        }
    }

    @Override
    public byte[] position() {
        return new byte[0];
    }

    @Override
    public void seek(byte[] position) {
    }

    @Override
    public boolean hasNext() {
        this.data = null;
        while (this.ids.hasNext()) {
            try {
                BaseElement t;
                QueryTypeParam param = this.ids.next();
                String addr = this.nodePartitioner.partition(this.graph, param.getCode());
                StreamKvIterator<E> itr = this.iteratorMap.get(addr);
                if (itr == null || !itr.hasNext() || !Arrays.equals((t = (BaseElement)itr.next()).id().asBytes(), param.getStart())) continue;
                this.data = t;
                return true;
            }
            catch (PDException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    @Override
    public E next() {
        if (this.data == null) {
            throw new NoSuchElementException();
        }
        return this.data;
    }
}

