/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.query;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.query.Tuple2;

public class StreamSortedIterator<E>
implements HgKvIterator<E> {
    private final List<HgKvIterator<E>> iterators;
    private final PriorityBlockingQueue<Tuple2<E, Integer>> pq;
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public StreamSortedIterator(List<HgKvIterator<E>> iterators, Comparator<E> comparator) {
        this.iterators = iterators;
        this.pq = new PriorityBlockingQueue(iterators.size(), (o1, o2) -> comparator.compare(o1.getV1(), o2.getV1()));
    }

    private void initializeQueue() {
        if (this.initialized.get()) {
            return;
        }
        AtomicInteger index = new AtomicInteger(0);
        this.iterators.stream().map(itr -> new Tuple2(itr, (Object)index.getAndIncrement())).collect(Collectors.toList()).parallelStream().forEach(tuple -> {
            HgKvIterator itr = (HgKvIterator)tuple.getV1();
            if (itr.hasNext()) {
                this.pq.offer(new Tuple2(itr.next(), (Object)((Integer)tuple.getV2())));
            }
        });
        this.initialized.set(true);
    }

    private HgKvIterator<E> getTopIterator() {
        Tuple2<E, Integer> entry = this.pq.peek();
        if (entry != null) {
            return this.iterators.get((Integer)entry.getV2());
        }
        return null;
    }

    @Override
    public byte[] key() {
        this.initializeQueue();
        HgKvIterator<E> itr = this.getTopIterator();
        if (itr != null) {
            return itr.key();
        }
        return null;
    }

    @Override
    public byte[] value() {
        this.initializeQueue();
        HgKvIterator<E> itr = this.getTopIterator();
        if (itr != null) {
            return itr.value();
        }
        return null;
    }

    @Override
    public void close() {
        this.iterators.forEach(HgKvIterator::close);
    }

    @Override
    public byte[] position() {
        this.initializeQueue();
        HgKvIterator<E> itr = this.getTopIterator();
        if (itr != null) {
            return itr.position();
        }
        return null;
    }

    @Override
    public void seek(byte[] position) {
        this.initializeQueue();
        HgKvIterator<E> itr = this.getTopIterator();
        if (itr != null) {
            itr.seek(position);
        }
    }

    @Override
    public boolean hasNext() {
        this.initializeQueue();
        return !this.pq.isEmpty();
    }

    @Override
    public E next() {
        Tuple2<E, Integer> pair = this.pq.poll();
        assert (pair != null);
        if (this.iterators.get((Integer)pair.getV2()).hasNext()) {
            this.pq.offer(Tuple2.of(this.iterators.get((Integer)pair.getV2()).next(), (Object)((Integer)pair.getV2())));
        }
        return (E)pair.getV1();
    }
}

