/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.HgKvOrderedIterator;
import org.apache.hugegraph.store.HgPageSize;
import org.apache.hugegraph.store.client.grpc.KvBatchScanner;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvBatchScannerMerger
implements KvCloseableIterator<HgKvIterator<HgKvEntry>>,
HgPageSize {
    private static final Logger log = LoggerFactory.getLogger(KvBatchScannerMerger.class);
    static int maxWaitCount = PropertyUtil.getInt("net.kv.scanner.wait.timeout", 60);
    protected final BlockingQueue<Supplier<HgKvIterator<HgKvEntry>>> queue = new LinkedBlockingQueue<Supplier<HgKvIterator<HgKvEntry>>>();
    private final KvBatchScanner.TaskSplitter taskSplitter;
    private final List<KvBatchScanner> scanners = new CopyOnWriteArrayList<KvBatchScanner>();
    private Supplier<HgKvIterator<HgKvEntry>> current = null;

    public KvBatchScannerMerger(KvBatchScanner.TaskSplitter splitter) {
        this.taskSplitter = splitter;
        splitter.setNotifier(this);
    }

    public void startTask() {
        this.taskSplitter.splitTask();
    }

    public void dataArrived(KvBatchScanner scanner, Supplier<HgKvIterator<HgKvEntry>> supplier) throws InterruptedException {
        this.queue.put(supplier);
    }

    @Override
    public boolean hasNext() {
        int waitTime = 0;
        while (this.current == null) {
            try {
                if (this.queue.size() == 0 && this.scanners.size() <= 0 && this.taskSplitter.isFinished()) break;
                this.current = this.queue.poll(1L, TimeUnit.SECONDS);
                if (this.current != null) continue;
                this.sendTimeout();
                if (++waitTime <= maxWaitCount) continue;
                log.error("KvBatchScanner wait data timeout {}, closeables is {}, task is {}", new Object[]{waitTime, this.scanners.size(), this.taskSplitter.isFinished()});
                break;
            }
            catch (InterruptedException e) {
                log.error("hasNext interrupted {}", (Throwable)e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this.current != null && this.current != KvBatchScanner.NO_DATA;
    }

    @Override
    public HgKvIterator<HgKvEntry> next() {
        HgKvIterator<HgKvEntry> iterator = null;
        if (this.current != null) {
            iterator = this.current.get();
        }
        this.current = null;
        return iterator;
    }

    @Override
    public void close() {
        this.taskSplitter.close();
        this.scanners.forEach(c -> c.close());
    }

    private void sendTimeout() {
        this.scanners.forEach(v -> v.sendResponse());
    }

    @Override
    public long getPageSize() {
        return 0L;
    }

    public void registerScanner(KvBatchScanner closeable) {
        this.scanners.add(closeable);
    }

    public int unregisterScanner(KvBatchScanner closeable) {
        this.scanners.remove(closeable);
        try {
            this.taskSplitter.splitTask();
        }
        catch (Exception e) {
            log.error("exception ", (Throwable)e);
        }
        return this.taskSplitter.isFinished() && this.scanners.size() == 0 ? -1 : this.scanners.size();
    }

    public int getScannerCount() {
        return this.scanners.size();
    }

    static class SortedScannerMerger
    extends KvBatchScannerMerger {
        private final Map<KvBatchScanner, ScannerDataQueue> scannerQueues = new ConcurrentHashMap<KvBatchScanner, ScannerDataQueue>();

        public SortedScannerMerger(KvBatchScanner.TaskSplitter splitter) {
            super(splitter);
            this.queue.add(() -> new HgKvIterator<HgKvEntry>(){
                private ScannerDataQueue iterator;
                private int currentSN = 0;
                private HgKvEntry entry;

                @Override
                public byte[] key() {
                    return this.entry.key();
                }

                @Override
                public byte[] value() {
                    return this.entry.value();
                }

                @Override
                public void close() {
                }

                @Override
                public byte[] position() {
                    return new byte[0];
                }

                @Override
                public void seek(byte[] position) {
                    throw new RuntimeException("not implemented");
                }

                @Override
                public boolean hasNext() {
                    if (this.iterator == null || !this.iterator.hasNext() || this.currentSN != this.iterator.sn()) {
                        this.iterator = this.selectIterator();
                    }
                    if (this.iterator != null) {
                        this.currentSN = this.iterator.sn();
                    }
                    return this.iterator != null;
                }

                @Override
                public HgKvEntry next() {
                    this.entry = this.iterator.next();
                    return this.entry;
                }
            });
        }

        private ScannerDataQueue selectIterator() {
            int sn = Integer.MAX_VALUE;
            ScannerDataQueue current = null;
            while (current == null && !this.scannerQueues.isEmpty()) {
                for (KvBatchScanner key : this.scannerQueues.keySet()) {
                    ScannerDataQueue kvItr = this.scannerQueues.get(key);
                    if (!kvItr.hasNext()) {
                        this.scannerQueues.remove(key);
                        continue;
                    }
                    if (kvItr.sn() > sn) continue;
                    sn = kvItr.sn();
                    current = kvItr;
                }
            }
            return current;
        }

        @Override
        public void registerScanner(KvBatchScanner scanner) {
            super.registerScanner(scanner);
            this.scannerQueues.putIfAbsent(scanner, new ScannerDataQueue());
        }

        @Override
        public int unregisterScanner(KvBatchScanner scanner) {
            this.dataArrived(scanner, KvBatchScanner.NO_DATA);
            return super.unregisterScanner(scanner);
        }

        @Override
        public void dataArrived(KvBatchScanner scanner, Supplier<HgKvIterator<HgKvEntry>> supplier) {
            this.scannerQueues.putIfAbsent(scanner, new ScannerDataQueue());
            this.scannerQueues.get(scanner).add(supplier);
        }
    }

    static class ScannerDataQueue {
        private BlockingQueue<Supplier<HgKvIterator<HgKvEntry>>> queue = new LinkedBlockingQueue<Supplier<HgKvIterator<HgKvEntry>>>();
        private HgKvOrderedIterator<HgKvEntry> iterator = null;
        private int currentSN = 0;
        private HgKvEntry entry;

        public int sn() {
            return this.currentSN;
        }

        public void add(Supplier<HgKvIterator<HgKvEntry>> supplier) {
            if (this.queue != null) {
                this.queue.add(supplier);
            }
        }

        public boolean hasNext() {
            while (this.entry == null && this.queue != null) {
                try {
                    int waitTime = 0;
                    Supplier<HgKvIterator<HgKvEntry>> current = this.queue.poll(1L, TimeUnit.SECONDS);
                    if (current == null) {
                        if (++waitTime <= maxWaitCount) continue;
                        break;
                    }
                    if (current == KvBatchScanner.NO_DATA) {
                        this.queue = null;
                        break;
                    }
                    this.iterator = (HgKvOrderedIterator)current.get();
                    if (this.iterator != null && this.iterator.hasNext()) {
                        this.moveNext();
                        continue;
                    }
                    this.iterator = null;
                }
                catch (InterruptedException e) {
                    log.error("hasNext interrupted {}", (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.entry != null;
        }

        public HgKvEntry next() {
            HgKvEntry current = this.entry;
            this.moveNext();
            return current;
        }

        private void moveNext() {
            if (this.iterator.hasNext()) {
                this.entry = (HgKvEntry)this.iterator.next();
                this.currentSN = (int)this.iterator.getSequence();
            } else {
                this.entry = null;
                this.iterator = null;
            }
        }
    }
}

