/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.store.client.HgNodePartition;
import org.apache.hugegraph.store.client.HgNodePartitionerBuilder;
import org.apache.hugegraph.store.client.HgStoreNode;
import org.apache.hugegraph.store.client.HgStoreNodeManager;
import org.apache.hugegraph.store.client.HgStoreNodeNotifier;
import org.apache.hugegraph.store.client.HgStoreNodePartitioner;
import org.apache.hugegraph.store.client.HgStoreNodeProvider;
import org.apache.hugegraph.store.client.HgStoreNotice;
import org.apache.hugegraph.store.client.type.HgNodeStatus;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HgStoreNodePartitionerImpl
implements HgStoreNodePartitioner,
HgStoreNodeProvider,
HgStoreNodeNotifier {
    private static final Logger log = LoggerFactory.getLogger(HgStoreNodePartitionerImpl.class);
    private PDClient pdClient;
    private HgStoreNodeManager nodeManager;

    protected HgStoreNodePartitionerImpl() {
    }

    public HgStoreNodePartitionerImpl(PDClient pdClient, HgStoreNodeManager nodeManager) {
        this.pdClient = pdClient;
        this.nodeManager = nodeManager;
    }

    @Override
    public int partition(HgNodePartitionerBuilder builder, String graphName, byte[] startKey, byte[] endKey) {
        try {
            HashSet<HgNodePartition> partitions = null;
            if (HgStoreClientConst.ALL_PARTITION_OWNER == startKey) {
                List stores = this.pdClient.getActiveStores(graphName);
                partitions = new HashSet<HgNodePartition>(stores.size());
                for (Metapb.Store store : stores) {
                    partitions.add(HgNodePartition.of(store.getId(), -1));
                }
            } else if (endKey == HgStoreClientConst.EMPTY_BYTES || startKey == endKey || Arrays.equals(startKey, endKey)) {
                KVPair partShard = this.pdClient.getPartition(graphName, startKey);
                Metapb.Shard leader = (Metapb.Shard)partShard.getValue();
                partitions = new HashSet();
                partitions.add(HgNodePartition.of(leader.getStoreId(), this.pdClient.keyToCode(graphName, startKey)));
            } else {
                log.warn("StartOwnerkey is not equal to endOwnerkey, which is meaningless!!, It is a error!!");
                List stores = this.pdClient.getActiveStores(graphName);
                partitions = new HashSet(stores.size());
                for (Metapb.Store store : stores) {
                    partitions.add(HgNodePartition.of(store.getId(), -1));
                }
            }
            builder.setPartitions(partitions);
        }
        catch (PDException e) {
            log.error("An error occurred while getting partition information :{}", (Object)e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        return 0;
    }

    @Override
    public int partition(HgNodePartitionerBuilder builder, String graphName, int startKey, int endKey) {
        try {
            KVPair partShard;
            HashSet<HgNodePartition> partitions = new HashSet<HgNodePartition>();
            Metapb.Partition partition = null;
            while ((partition == null || partition.getEndKey() < (long)endKey) && startKey < 65535 && (partShard = this.pdClient.getPartitionByCode(graphName, (long)startKey)) != null) {
                partition = (Metapb.Partition)partShard.getKey();
                Metapb.Shard leader = (Metapb.Shard)partShard.getValue();
                partitions.add(HgNodePartition.of(leader.getStoreId(), startKey, (int)partition.getStartKey(), (int)partition.getEndKey()));
                startKey = (int)partition.getEndKey();
            }
            builder.setPartitions(partitions);
        }
        catch (PDException e) {
            log.error("An error occurred while getting partition information :{}", (Object)e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        return 0;
    }

    @Override
    public int partition(HgNodePartitionerBuilder builder, String graphName, int partitionId) {
        try {
            HashSet<HgNodePartition> partitions = new HashSet<HgNodePartition>();
            Metapb.Partition partition = null;
            KVPair partShard = this.pdClient.getPartitionById(graphName, partitionId);
            if (partShard != null) {
                partition = (Metapb.Partition)partShard.getKey();
                Metapb.Shard leader = (Metapb.Shard)partShard.getValue();
                partitions.add(HgNodePartition.of(leader.getStoreId(), (int)partition.getStartKey()));
            }
            builder.setPartitions(partitions);
        }
        catch (PDException e) {
            log.error("An error occurred while getting partition information :{}", (Object)e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
        return 0;
    }

    @Override
    public String partition(String graphName, byte[] startKey) throws PDException {
        Metapb.Shard shard = (Metapb.Shard)this.pdClient.getPartition(graphName, startKey).getValue();
        return this.pdClient.getStore(shard.getStoreId()).getAddress();
    }

    @Override
    public String partition(String graphName, int code) throws PDException {
        Metapb.Shard shard = (Metapb.Shard)this.pdClient.getPartitionByCode(graphName, (long)code).getValue();
        return this.pdClient.getStore(shard.getStoreId()).getAddress();
    }

    @Override
    public HgStoreNode apply(String graphName, Long nodeId) {
        try {
            Metapb.Store store = this.pdClient.getStore(nodeId.longValue());
            return this.nodeManager.getNodeBuilder().setNodeId(store.getId()).setAddress(store.getAddress()).build();
        }
        catch (PDException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public int notice(String graphName, HgStoreNotice storeNotice) {
        log.warn(storeNotice.toString());
        if (storeNotice.getPartitionLeaders() != null) {
            storeNotice.getPartitionLeaders().forEach((partId, leader) -> {
                this.pdClient.updatePartitionLeader(graphName, partId.intValue(), leader.longValue());
                log.warn("updatePartitionLeader:{}-{}-{}", new Object[]{graphName, partId, leader});
            });
        }
        if (storeNotice.getPartitionIds() != null) {
            storeNotice.getPartitionIds().forEach(partId -> this.pdClient.invalidPartitionCache(graphName, partId.intValue()));
        }
        if (!storeNotice.getNodeStatus().equals((Object)HgNodeStatus.PARTITION_COMMON_FAULT) && !storeNotice.getNodeStatus().equals((Object)HgNodeStatus.NOT_PARTITION_LEADER)) {
            this.pdClient.invalidPartitionCache();
            log.warn("invalidPartitionCache:{} ", (Object)storeNotice.getNodeStatus());
        }
        return 0;
    }

    public Metapb.Graph delGraph(String graphName) {
        try {
            return this.pdClient.delGraph(graphName);
        }
        catch (PDException e) {
            log.error("delGraph {} exception, {}", (Object)graphName, (Object)e.getMessage());
            return null;
        }
    }

    public void setNodeManager(HgStoreNodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    @Override
    public List<String> getStores(String graphName) throws PDException {
        List list = this.pdClient.getCache().getLeaderStoreAddresses();
        if (list.isEmpty()) {
            return this.pdClient.getActiveStores(graphName).stream().map(Metapb.Store::getAddress).collect(Collectors.toList());
        }
        return list;
    }
}

