/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class MultiMap {
    private MultiMap() {
    }

    public static <K, V> boolean putAll(Map<K, Set<V>> map, K key, Collection<V> values) {
        return MultiMap.getMapSet(map, key).addAll(values);
    }

    public static <K, V> boolean put(Map<K, Set<V>> map, K key, V value) {
        return MultiMap.getMapSet(map, key).add(value);
    }

    public static <K, V> boolean containsEntry(Map<K, Set<V>> map, K key, V value) {
        Set<V> set = map.get(key);
        return set != null && set.contains(value);
    }

    public static <K, V> Set<V> get(Map<K, Set<V>> map, K key) {
        Set<V> set = MultiMap.getMapSet(map, key);
        return set == null ? Collections.emptySet() : set;
    }

    private static <K, V> Set<V> getMapSet(Map<K, Set<V>> map, K key) {
        Set<V> set = map.get(key);
        if (set == null) {
            set = new LinkedHashSet<V>();
            map.put(key, set);
        }
        return set;
    }
}

