/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyVertexProperty;

public interface VertexProperty<V>
extends Property<V>,
Element {
    public static final String DEFAULT_LABEL = "vertexProperty";

    @Override
    public Vertex element();

    @Override
    default public Graph graph() {
        return this.element().graph();
    }

    @Override
    default public String label() {
        return this.key();
    }

    public static <V> VertexProperty<V> empty() {
        return EmptyVertexProperty.instance();
    }

    public <U> Iterator<Property<U>> properties(String ... var1);

    public static class Exceptions {
        private Exceptions() {
        }

        public static UnsupportedOperationException userSuppliedIdsNotSupported() {
            return new UnsupportedOperationException("VertexProperty does not support user supplied identifiers");
        }

        public static UnsupportedOperationException userSuppliedIdsOfThisTypeNotSupported() {
            return new UnsupportedOperationException("VertexProperty does not support user supplied identifiers of this type");
        }

        public static UnsupportedOperationException multiPropertiesNotSupported() {
            return new UnsupportedOperationException("Multiple properties on a vertex is not supported");
        }

        public static UnsupportedOperationException identicalMultiPropertiesNotSupported() {
            return new UnsupportedOperationException("Multiple properties on a vertex is supported, but a single key may not hold the same value more than once");
        }

        public static UnsupportedOperationException metaPropertiesNotSupported() {
            return new UnsupportedOperationException("Properties on a vertex property is not supported");
        }
    }

    public static enum Cardinality {
        single,
        list,
        set;

    }
}

