/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.MemoryComputing;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class ProfileStep<S>
extends AbstractStep<S, S>
implements MemoryComputing<MutableMetrics> {
    private MutableMetrics metrics;
    private boolean onGraphComputer = false;

    public ProfileStep(Traversal.Admin traversal) {
        super(traversal);
    }

    public MutableMetrics getMetrics() {
        if (this.traversal.isLocked()) {
            this.initializeIfNeeded();
        }
        return this.metrics;
    }

    @Override
    public Traverser.Admin<S> next() {
        Object start = null;
        this.initializeIfNeeded();
        this.metrics.start();
        try {
            Object object = start = super.next();
            return object;
        }
        finally {
            if (start != null) {
                this.metrics.finish(start.bulk());
                if (this.onGraphComputer) {
                    this.getTraversal().getSideEffects().add(this.getId(), this.metrics);
                    this.metrics = null;
                }
            } else {
                this.metrics.stop();
                if (this.onGraphComputer) {
                    this.getTraversal().getSideEffects().add(this.getId(), this.metrics);
                    this.metrics = null;
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.initializeIfNeeded();
        this.metrics.start();
        boolean ret = super.hasNext();
        this.metrics.stop();
        return ret;
    }

    @Override
    protected Traverser.Admin<S> processNextStart() throws NoSuchElementException {
        return this.starts.next();
    }

    private void initializeIfNeeded() {
        if (null == this.metrics) {
            this.onGraphComputer = TraversalHelper.onGraphComputer(this.getTraversal());
            this.metrics = new MutableMetrics(this.getPreviousStep().getId(), this.getPreviousStep().toString());
            Step previousStep = this.getPreviousStep();
            if (previousStep instanceof Profiling) {
                ((Profiling)((Object)previousStep)).setMetrics(this.metrics);
            }
        }
    }

    @Override
    public MemoryComputeKey<MutableMetrics> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), ProfileBiOperator.instance(), false, true);
    }

    @Override
    public ProfileStep<S> clone() {
        ProfileStep clone = (ProfileStep)super.clone();
        clone.metrics = null;
        return clone;
    }

    public void start() {
        this.initializeIfNeeded();
        this.metrics.start();
    }

    public void stop() {
        this.metrics.stop();
    }

    public static class ProfileBiOperator
    implements BinaryOperator<MutableMetrics>,
    Serializable {
        private static final ProfileBiOperator INSTANCE = new ProfileBiOperator();

        @Override
        public MutableMetrics apply(MutableMetrics metricsA, MutableMetrics metricsB) {
            metricsA.aggregate(metricsB);
            return metricsA;
        }

        public static final ProfileBiOperator instance() {
            return INSTANCE;
        }
    }
}

